/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.logbackadapter;

import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.ElementSelector;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.joran.spi.RuleStore;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.processor.DefaultProcessor;
import com.alibaba.nacos.common.log.NacosLogbackConfigurator;
import com.alibaba.nacos.logbackadapter.NacosClientPropertyModel;
import com.alibaba.nacos.logbackadapter.NacosClientPropertyModelAction;
import com.alibaba.nacos.logbackadapter.NacosClientPropertyModelHandler;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;

public class NacosLogbackConfiguratorAdapterV2
extends JoranConfigurator
implements NacosLogbackConfigurator {
    public void registerSafeConfiguration(Model top) {
    }

    protected void addModelHandlerAssociations(DefaultProcessor defaultProcessor) {
        defaultProcessor.addHandler(NacosClientPropertyModel.class, (handlerContext, handlerMic) -> new NacosClientPropertyModelHandler(this.context));
        super.addModelHandlerAssociations(defaultProcessor);
    }

    public void addElementSelectorAndActionAssociations(RuleStore ruleStore) {
        super.addElementSelectorAndActionAssociations(ruleStore);
        ruleStore.addRule(new ElementSelector("configuration/nacosClientProperty"), NacosClientPropertyModelAction::new);
    }

    public int getVersion() {
        return 2;
    }

    public void setContext(Object loggerContext) {
        super.setContext((Context)loggerContext);
    }

    public void configure(URL url) throws Exception {
        InputStream in = null;
        try {
            URLConnection urlConnection = url.openConnection();
            urlConnection.setUseCaches(false);
            in = urlConnection.getInputStream();
            this.doConfigure(in, url.toExternalForm());
        }
        catch (IOException ioe) {
            String errMsg = "Could not open URL [" + url + "].";
            this.addError(errMsg, ioe);
            throw new JoranException(errMsg, (Throwable)ioe);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ioe) {
                    String errMsg = "Could not close input stream";
                    this.addError(errMsg, ioe);
                    throw new JoranException(errMsg, (Throwable)ioe);
                }
            }
        }
    }
}

