/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.logger.adapter.logback14;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.LoggerContextListener;
import ch.qos.logback.classic.turbo.TurboFilter;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.spi.FilterReply;
import com.alibaba.nacos.common.logging.NacosLoggingAdapter;
import com.alibaba.nacos.common.logging.NacosLoggingProperties;
import com.alibaba.nacos.common.utils.ResourceUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.logger.adapter.logback14.NacosLogbackConfiguratorAdapterV2;
import java.util.Iterator;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;

public class LogbackNacosLoggingAdapter
implements NacosLoggingAdapter {
    private static final String NACOS_LOGBACK_LOCATION = "classpath:nacos-logback14.xml";
    private static final String LOGBACK_CLASSES = "ch.qos.logback.classic.Logger";
    private NacosLogbackConfiguratorAdapterV2 configurator;

    public boolean isAdaptedLogger(Class<?> loggerClass) {
        Class<?> expectedLoggerClass = this.getExpectedLoggerClass();
        if (null == expectedLoggerClass || !expectedLoggerClass.isAssignableFrom(loggerClass)) {
            return false;
        }
        return this.isUpperLogback13();
    }

    private Class<?> getExpectedLoggerClass() {
        try {
            return Class.forName(LOGBACK_CLASSES);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private boolean isUpperLogback13() {
        try {
            Class.forName("ch.qos.logback.core.model.Model");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public boolean isNeedReloadConfiguration() {
        return false;
    }

    public String getDefaultConfigLocation() {
        return NACOS_LOGBACK_LOCATION;
    }

    public void loadConfiguration(NacosLoggingProperties loggingProperties) {
        this.checkConfiguratorExist();
        String location = loggingProperties.getLocation();
        this.configurator.setLoggingProperties(loggingProperties);
        LoggerContext loggerContext = this.loadConfigurationOnStart(location);
        this.addNacosLogFilterIfNecessary(loggerContext);
        if (this.hasNoListener(loggerContext)) {
            this.addListener(loggerContext, location);
        }
    }

    private void addNacosLogFilterIfNecessary(LoggerContext loggerContext) {
        if (!loggerContext.getTurboFilterList().isEmpty() && loggerContext.getTurboFilterList().get(0) instanceof NacosLogTurboFilter) {
            return;
        }
        if (!loggerContext.getTurboFilterList().isEmpty() && !(loggerContext.getTurboFilterList().get(0) instanceof NacosLogTurboFilter)) {
            Iterator iterator = loggerContext.getTurboFilterList().iterator();
            while (iterator.hasNext()) {
                if (!(iterator.next() instanceof NacosLogTurboFilter)) continue;
                iterator.remove();
            }
        }
        loggerContext.getTurboFilterList().add(0, (Object)new NacosLogTurboFilter());
    }

    private synchronized void checkConfiguratorExist() {
        if (null == this.configurator) {
            this.configurator = new NacosLogbackConfiguratorAdapterV2();
        }
    }

    private boolean hasNoListener(LoggerContext loggerContext) {
        for (LoggerContextListener loggerContextListener : loggerContext.getCopyOfListenerList()) {
            if (!(loggerContextListener instanceof NacosLoggerContextListener)) continue;
            return false;
        }
        return true;
    }

    private LoggerContext loadConfigurationOnStart(String location) {
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        this.configurator.setContext((Context)loggerContext);
        if (StringUtils.isNotBlank((String)location)) {
            try {
                this.configurator.configure(ResourceUtils.getResourceUrl((String)location));
            }
            catch (Exception e) {
                throw new IllegalStateException("Could not initialize Logback Nacos logging from " + location, e);
            }
        }
        return loggerContext;
    }

    private void addListener(LoggerContext loggerContext, String location) {
        loggerContext.addListener((LoggerContextListener)new NacosLoggerContextListener(location));
    }

    class NacosLoggerContextListener
    implements LoggerContextListener {
        private final String location;

        NacosLoggerContextListener(String location) {
            this.location = location;
        }

        public boolean isResetResistant() {
            return true;
        }

        public void onReset(LoggerContext context) {
            LogbackNacosLoggingAdapter.this.loadConfigurationOnStart(this.location);
        }

        public void onStart(LoggerContext context) {
        }

        public void onStop(LoggerContext context) {
        }

        public void onLevelChange(Logger logger, Level level) {
        }
    }

    class NacosLogTurboFilter
    extends TurboFilter {
        NacosLogTurboFilter() {
        }

        public FilterReply decide(Marker marker, Logger logger, Level level, String s, Object[] objects, Throwable throwable) {
            if (logger.getName().startsWith("com.alibaba.nacos") && logger.getEffectiveLevel().levelInt <= level.levelInt) {
                return FilterReply.ACCEPT;
            }
            return FilterReply.NEUTRAL;
        }
    }
}

