/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.aliyun;

import com.alibaba.nacos.api.utils.StringUtils;
import com.alibaba.nacos.client.aliyun.AliyunConst;
import com.alibaba.nacos.client.aliyun.KmsUtils;
import com.alibaba.nacos.client.aliyun.MD5Utils;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KmsLocalCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(KmsLocalCache.class);
    private final Cache<String, LocalCacheItem> encryptedContentCache;

    KmsLocalCache(Properties properties) {
        int cacheSize = KmsUtils.parsePropertyValue(properties, "nacos.config.encryption.kms.local.cache.maxSize", 1000);
        int afterAccessDurationSeconds = KmsUtils.parsePropertyValue(properties, "nacos.config.encryption.kms.local.cache.afterAccessDuration", 3600);
        int afterWriteDurationSeconds = KmsUtils.parsePropertyValue(properties, "nacos.config.encryption.kms.local.cache.afterWriteDuration", 86400);
        this.encryptedContentCache = CacheBuilder.newBuilder().maximumSize((long)cacheSize).expireAfterAccess((long)afterAccessDurationSeconds, TimeUnit.SECONDS).expireAfterWrite((long)afterWriteDurationSeconds, TimeUnit.SECONDS).build();
    }

    public LocalCacheItem get(String key) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return null;
        }
        try {
            return (LocalCacheItem)this.encryptedContentCache.getIfPresent((Object)key);
        }
        catch (Exception e) {
            LOGGER.error("get encrypted content from local cache failed, key: {}", (Object)key, (Object)e);
            return null;
        }
    }

    public void put(String key, LocalCacheItem localCacheItem) {
        if (StringUtils.isBlank((CharSequence)key) || localCacheItem == null) {
            return;
        }
        try {
            this.encryptedContentCache.put((Object)key, (Object)localCacheItem);
        }
        catch (Exception e) {
            LOGGER.error("put encrypted content to local cache failed, key: {}", (Object)key, (Object)e);
        }
    }

    public void remove(String key) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return;
        }
        this.encryptedContentCache.invalidate((Object)key);
    }

    public static class LocalCacheItem {
        private final String encryptedDataKey;
        private final String encryptedContent;
        private final String encryptedContentMD5;
        private final String plainDataKey;
        private final String plainContent;

        public LocalCacheItem(String encryptedDataKey, String encryptedContent, String plainDataKey) {
            this.encryptedDataKey = encryptedDataKey;
            this.plainDataKey = plainDataKey;
            this.encryptedContent = null;
            this.encryptedContentMD5 = MD5Utils.md5Hex(encryptedContent, AliyunConst.ENCODE_UTF8);
            this.plainContent = null;
        }

        public LocalCacheItem(String encryptedContent, String plainContent) {
            this.encryptedDataKey = null;
            this.plainDataKey = null;
            this.encryptedContent = null;
            this.encryptedContentMD5 = MD5Utils.md5Hex(encryptedContent, AliyunConst.ENCODE_UTF8);
            this.plainContent = plainContent;
        }

        public String getEncryptedDataKey() {
            return this.encryptedDataKey;
        }

        public String getEncryptedContent() {
            return this.encryptedContent;
        }

        public String getPlainDataKey() {
            return this.plainDataKey;
        }

        public String getPlainContent() {
            return this.plainContent;
        }

        public String getEncryptedContentMD5() {
            return this.encryptedContentMD5;
        }

        public String toString() {
            return "LocalCacheItem{encryptedDataKey='" + this.encryptedDataKey + '\'' + ", encryptedContent='" + this.encryptedContent + '\'' + ", encryptedContentMD5='" + this.encryptedContentMD5 + '\'' + ", plainDataKey='" + this.plainDataKey + '\'' + ", plainContent='" + this.plainContent + '\'' + '}';
        }
    }
}

