/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.naming.core;

import com.alibaba.fastjson.JSON;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.api.naming.pojo.ServiceInfo;
import com.alibaba.nacos.client.naming.backups.FailoverReactor;
import com.alibaba.nacos.client.naming.cache.DiskCache;
import com.alibaba.nacos.client.naming.core.Balancer;
import com.alibaba.nacos.client.naming.core.EventDispatcher;
import com.alibaba.nacos.client.naming.core.PushRecver;
import com.alibaba.nacos.client.naming.net.NamingProxy;
import com.alibaba.nacos.client.naming.utils.LogUtils;
import com.alibaba.nacos.client.naming.utils.NetUtils;
import com.alibaba.nacos.client.naming.utils.StringUtils;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class HostReactor {
    public static final long DEFAULT_DELAY = 1000L;
    public long updateHoldInterval = 5000L;
    private final Map<String, ScheduledFuture<?>> futureMap = new HashMap();
    private Map<String, ServiceInfo> serviceInfoMap;
    private Map<String, Object> updatingMap;
    private PushRecver pushRecver;
    private EventDispatcher eventDispatcher;
    private NamingProxy serverProxy;
    private FailoverReactor failoverReactor;
    private String cacheDir;
    private ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r, "com.alibaba.nacos.client.naming.updater");
            thread.setDaemon(true);
            return thread;
        }
    });

    public HostReactor(EventDispatcher eventDispatcher, NamingProxy serverProxy, String cacheDir, boolean loadCacheAtStart) {
        this.eventDispatcher = eventDispatcher;
        this.serverProxy = serverProxy;
        this.cacheDir = cacheDir;
        this.serviceInfoMap = loadCacheAtStart ? new ConcurrentHashMap<String, ServiceInfo>(DiskCache.read(this.cacheDir)) : new ConcurrentHashMap<String, ServiceInfo>(16);
        this.updatingMap = new ConcurrentHashMap<String, Object>();
        this.failoverReactor = new FailoverReactor(this, cacheDir);
        this.pushRecver = new PushRecver(this);
    }

    public Map<String, ServiceInfo> getServiceInfoMap() {
        return this.serviceInfoMap;
    }

    public synchronized ScheduledFuture<?> addTask(UpdateTask task) {
        return this.executor.schedule(task, 1000L, TimeUnit.MILLISECONDS);
    }

    public ServiceInfo processServiceJSON(String json) {
        ServiceInfo serviceInfo = (ServiceInfo)JSON.parseObject((String)json, ServiceInfo.class);
        ServiceInfo oldService = this.serviceInfoMap.get(serviceInfo.getKey());
        if (serviceInfo.getHosts() == null || !serviceInfo.validate()) {
            return oldService;
        }
        if (oldService != null) {
            String key;
            Instance host;
            if (oldService.getLastRefTime() > serviceInfo.getLastRefTime()) {
                LogUtils.LOG.warn("out of date data received, old-t: " + oldService.getLastRefTime() + ", new-t: " + serviceInfo.getLastRefTime());
            }
            this.serviceInfoMap.put(serviceInfo.getKey(), serviceInfo);
            HashMap<String, Instance> oldHostMap = new HashMap<String, Instance>(oldService.getHosts().size());
            for (Object host2 : oldService.getHosts()) {
                oldHostMap.put(host2.toInetAddr(), (Instance)host2);
            }
            HashMap<String, Instance> newHostMap = new HashMap<String, Instance>(serviceInfo.getHosts().size());
            for (Instance host3 : serviceInfo.getHosts()) {
                newHostMap.put(host3.toInetAddr(), host3);
            }
            HashSet<Instance> modHosts = new HashSet<Instance>();
            HashSet<Instance> newHosts = new HashSet<Instance>();
            HashSet<Instance> remvHosts = new HashSet<Instance>();
            ArrayList newServiceHosts = new ArrayList(newHostMap.entrySet());
            for (Map.Entry entry : newServiceHosts) {
                host = (Instance)entry.getValue();
                key = (String)entry.getKey();
                if (oldHostMap.containsKey(key) && !StringUtils.equals(host.toString(), ((Instance)oldHostMap.get(key)).toString())) {
                    modHosts.add(host);
                    continue;
                }
                if (oldHostMap.containsKey(key)) continue;
                newHosts.add(host);
            }
            for (Map.Entry entry : oldHostMap.entrySet()) {
                host = (Instance)entry.getValue();
                key = (String)entry.getKey();
                if (newHostMap.containsKey(key) || newHostMap.containsKey(key)) continue;
                remvHosts.add(host);
            }
            if (newHosts.size() > 0) {
                LogUtils.LOG.info("new ips(" + newHosts.size() + ") service: " + serviceInfo.getName() + " -> " + JSON.toJSONString(newHosts));
            }
            if (remvHosts.size() > 0) {
                LogUtils.LOG.info("removed ips(" + remvHosts.size() + ") service: " + serviceInfo.getName() + " -> " + JSON.toJSONString(remvHosts));
            }
            if (modHosts.size() > 0) {
                LogUtils.LOG.info("modified ips(" + modHosts.size() + ") service: " + serviceInfo.getName() + " -> " + JSON.toJSONString(modHosts));
            }
            serviceInfo.setJsonFromServer(json);
            if (newHosts.size() > 0 || remvHosts.size() > 0 || modHosts.size() > 0) {
                this.eventDispatcher.serviceChanged(serviceInfo);
                DiskCache.write(serviceInfo, this.cacheDir);
            }
        } else {
            LogUtils.LOG.info("new ips(" + serviceInfo.ipCount() + ") service: " + serviceInfo.getName() + " -> " + JSON.toJSONString((Object)serviceInfo.getHosts()));
            this.serviceInfoMap.put(serviceInfo.getKey(), serviceInfo);
            this.eventDispatcher.serviceChanged(serviceInfo);
            serviceInfo.setJsonFromServer(json);
            DiskCache.write(serviceInfo, this.cacheDir);
        }
        LogUtils.LOG.info("current ips:(" + serviceInfo.ipCount() + ") service: " + serviceInfo.getName() + " -> " + JSON.toJSONString((Object)serviceInfo.getHosts()));
        return serviceInfo;
    }

    private ServiceInfo getSerivceInfo0(String serviceName, String clusters, String env) {
        String key = ServiceInfo.getKey((String)serviceName, (String)clusters, (String)env, (boolean)false);
        return this.serviceInfoMap.get(key);
    }

    private ServiceInfo getSerivceInfo0(String serviceName, String clusters, String env, boolean allIPs) {
        String key = ServiceInfo.getKey((String)serviceName, (String)clusters, (String)env, (boolean)allIPs);
        return this.serviceInfoMap.get(key);
    }

    public ServiceInfo getServiceInfo(String serviceName, String clusters, String env) {
        return this.getServiceInfo(serviceName, clusters, env, false);
    }

    public ServiceInfo getServiceInfo(String serviceName, String clusters) {
        String env = "";
        return this.getServiceInfo(serviceName, clusters, env, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceInfo getServiceInfo(String serviceName, String clusters, String env, boolean allIPs) {
        LogUtils.LOG.debug("failover-mode: " + this.failoverReactor.isFailoverSwitch());
        String key = ServiceInfo.getKey((String)serviceName, (String)clusters, (String)env, (boolean)allIPs);
        if (this.failoverReactor.isFailoverSwitch()) {
            return this.failoverReactor.getService(key);
        }
        ServiceInfo serviceObj = this.getSerivceInfo0(serviceName, clusters, env, allIPs);
        if (null == serviceObj) {
            serviceObj = new ServiceInfo(serviceName, clusters, env);
            if (allIPs) {
                serviceObj.setAllIPs(allIPs);
            }
            this.serviceInfoMap.put(serviceObj.getKey(), serviceObj);
            this.updatingMap.put(serviceName, new Object());
            if (allIPs) {
                this.updateService4AllIPNow(serviceName, clusters, env);
            } else {
                this.updateServiceNow(serviceName, clusters, env);
            }
            this.updatingMap.remove(serviceName);
        } else if (this.updatingMap.containsKey(serviceName) && this.updateHoldInterval > 0L) {
            ServiceInfo serviceInfo = serviceObj;
            synchronized (serviceInfo) {
                try {
                    serviceObj.wait(this.updateHoldInterval);
                }
                catch (InterruptedException e) {
                    LogUtils.LOG.error("[getServiceInfo]", "serviceName:" + serviceName + ", clusters:" + clusters + ", allIPs:" + allIPs, e);
                }
            }
        }
        this.scheduleUpdateIfAbsent(serviceName, clusters, env, allIPs);
        return this.serviceInfoMap.get(serviceObj.getKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleUpdateIfAbsent(String serviceName, String clusters, String env, boolean allIPs) {
        if (this.futureMap.get(ServiceInfo.getKey((String)serviceName, (String)clusters, (String)env, (boolean)allIPs)) != null) {
            return;
        }
        Map<String, ScheduledFuture<?>> map = this.futureMap;
        synchronized (map) {
            if (this.futureMap.get(ServiceInfo.getKey((String)serviceName, (String)clusters, (String)env, (boolean)allIPs)) != null) {
                return;
            }
            ScheduledFuture<?> future = this.addTask(new UpdateTask(serviceName, clusters, env, allIPs));
            this.futureMap.put(ServiceInfo.getKey((String)serviceName, (String)clusters, (String)env, (boolean)allIPs), future);
        }
    }

    public void updateService4AllIPNow(String serviceName, String clusters, String env) {
        this.updateService4AllIPNow(serviceName, clusters, env, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"NN_NAKED_NOTIFY"})
    public void updateService4AllIPNow(String serviceName, String clusters, String env, long timeout) {
        block7: {
            try {
                String result;
                HashMap<String, String> params = new HashMap<String, String>(8);
                params.put("dom", serviceName);
                params.put("clusters", clusters);
                params.put("udpPort", String.valueOf(this.pushRecver.getUDPPort()));
                ServiceInfo oldService = this.getSerivceInfo0(serviceName, clusters, env, true);
                if (oldService != null) {
                    params.put("checksum", oldService.getChecksum());
                }
                if (StringUtils.isNotEmpty(result = this.serverProxy.reqAPI("/nacos/v1/ns/api/srvAllIP", params))) {
                    ServiceInfo serviceInfo = this.processServiceJSON(result);
                    serviceInfo.setAllIPs(true);
                }
                if (oldService == null) break block7;
                ServiceInfo serviceInfo = oldService;
                synchronized (serviceInfo) {
                    oldService.notifyAll();
                }
            }
            catch (Exception e) {
                LogUtils.LOG.error("NA", "failed to update serviceName: " + serviceName, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"NN_NAKED_NOTIFY"})
    public void updateServiceNow(String serviceName, String clusters, String env) {
        ServiceInfo oldService = this.getSerivceInfo0(serviceName, clusters, env);
        try {
            String result;
            ServiceInfo params = new HashMap(8);
            params.put("dom", serviceName);
            params.put("clusters", clusters);
            params.put("udpPort", String.valueOf(this.pushRecver.getUDPPort()));
            params.put("env", env);
            params.put("clientIP", NetUtils.localIP());
            StringBuilder stringBuilder = new StringBuilder();
            for (String string : Balancer.UNCONSISTENT_SERVICE_WITH_ADDRESS_SERVER) {
                stringBuilder.append(string).append(",");
            }
            Balancer.UNCONSISTENT_SERVICE_WITH_ADDRESS_SERVER.clear();
            params.put("unconsistentDom", stringBuilder.toString());
            String envSpliter = ",";
            if (!StringUtils.isEmpty(env) && !env.contains(envSpliter)) {
                params.put((String)"useEnvId", (String)"true");
            }
            if (oldService != null) {
                params.put("checksum", oldService.getChecksum());
            }
            if (StringUtils.isNotEmpty(result = this.serverProxy.reqAPI("/nacos/v1/ns/api/srvIPXT", (Map<String, String>)params))) {
                this.processServiceJSON(result);
            }
        }
        catch (Exception e) {
            LogUtils.LOG.error("NA", "failed to update serviceName: " + serviceName, e);
        }
        finally {
            if (oldService != null) {
                ServiceInfo serviceInfo = oldService;
                synchronized (serviceInfo) {
                    oldService.notifyAll();
                }
            }
        }
    }

    public void refreshOnly(String serviceName, String clusters, String env, boolean allIPs) {
        try {
            HashMap<String, String> params = new HashMap<String, String>(16);
            params.put("dom", serviceName);
            params.put("clusters", clusters);
            params.put("udpPort", String.valueOf(this.pushRecver.getUDPPort()));
            params.put("unit", env);
            params.put("clientIP", NetUtils.localIP());
            String serviceSpliter = ",";
            StringBuilder stringBuilder = new StringBuilder();
            for (String string : Balancer.UNCONSISTENT_SERVICE_WITH_ADDRESS_SERVER) {
                stringBuilder.append(string).append(serviceSpliter);
            }
            Balancer.UNCONSISTENT_SERVICE_WITH_ADDRESS_SERVER.clear();
            params.put("unconsistentDom", stringBuilder.toString());
            String envSpliter = ",";
            if (!env.contains(envSpliter)) {
                params.put("useEnvId", "true");
            }
            if (allIPs) {
                this.serverProxy.reqAPI("/nacos/v1/ns/api/srvAllIP", params);
            } else {
                this.serverProxy.reqAPI("/nacos/v1/ns/api/srvIPXT", params);
            }
        }
        catch (Exception e) {
            LogUtils.LOG.error("NA", "failed to update serviceName: " + serviceName, e);
        }
    }

    public class UpdateTask
    implements Runnable {
        long lastRefTime = Long.MAX_VALUE;
        private String clusters;
        private String serviceName;
        private String env;
        private boolean allIPs = false;

        public UpdateTask(String serviceName, String clusters, String env) {
            this.serviceName = serviceName;
            this.clusters = clusters;
            this.env = env;
        }

        public UpdateTask(String serviceName, String clusters, String env, boolean allIPs) {
            this.serviceName = serviceName;
            this.clusters = clusters;
            this.env = env;
            this.allIPs = allIPs;
        }

        @Override
        public void run() {
            try {
                ServiceInfo serviceObj = (ServiceInfo)HostReactor.this.serviceInfoMap.get(ServiceInfo.getKey((String)this.serviceName, (String)this.clusters, (String)this.env, (boolean)this.allIPs));
                if (serviceObj == null) {
                    if (this.allIPs) {
                        HostReactor.this.updateService4AllIPNow(this.serviceName, this.clusters, this.env);
                    } else {
                        HostReactor.this.updateServiceNow(this.serviceName, this.clusters, this.env);
                        HostReactor.this.executor.schedule(this, 1000L, TimeUnit.MILLISECONDS);
                    }
                    return;
                }
                if (serviceObj.getLastRefTime() <= this.lastRefTime) {
                    if (this.allIPs) {
                        HostReactor.this.updateService4AllIPNow(this.serviceName, this.clusters, this.env);
                        serviceObj = (ServiceInfo)HostReactor.this.serviceInfoMap.get(ServiceInfo.getKey((String)this.serviceName, (String)this.clusters, (String)this.env, (boolean)true));
                    } else {
                        HostReactor.this.updateServiceNow(this.serviceName, this.clusters, this.env);
                        serviceObj = (ServiceInfo)HostReactor.this.serviceInfoMap.get(ServiceInfo.getKey((String)this.serviceName, (String)this.clusters, (String)this.env));
                    }
                } else {
                    HostReactor.this.refreshOnly(this.serviceName, this.clusters, this.env, this.allIPs);
                }
                HostReactor.this.executor.schedule(this, serviceObj.getCacheMillis(), TimeUnit.MILLISECONDS);
                this.lastRefTime = serviceObj.getLastRefTime();
            }
            catch (Throwable e) {
                LogUtils.LOG.warn("NA", "failed to update serviceName: " + this.serviceName, e);
            }
        }
    }
}

