/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.naming.core;

import com.alibaba.fastjson.JSON;
import com.alibaba.nacos.client.naming.core.HostReactor;
import com.alibaba.nacos.client.naming.utils.IoUtils;
import com.alibaba.nacos.client.naming.utils.LogUtils;
import com.alibaba.nacos.client.naming.utils.StringUtils;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.nio.charset.Charset;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;

public class PushRecver
implements Runnable {
    private ScheduledExecutorService executorService;
    public static final int UDP_MSS = 65536;
    private DatagramSocket udpSocket;
    private HostReactor hostReactor;

    public PushRecver(HostReactor hostReactor) {
        try {
            this.hostReactor = hostReactor;
            this.udpSocket = new DatagramSocket();
            this.executorService = new ScheduledThreadPoolExecutor(1, new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    Thread thread = new Thread(r);
                    thread.setDaemon(true);
                    thread.setName("com.alibaba.nacos.naming.push.receiver");
                    return thread;
                }
            });
            this.executorService.execute(this);
        }
        catch (Exception e) {
            LogUtils.LOG.error("NA", "init udp socket failed", e);
        }
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    String ack;
                    byte[] buffer = new byte[65536];
                    DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
                    this.udpSocket.receive(packet);
                    String json = new String(IoUtils.tryDecompress(packet.getData()), "UTF-8").trim();
                    LogUtils.LOG.info("received push data: " + json + " from " + packet.getAddress().toString());
                    PushPacket pushPacket = (PushPacket)JSON.parseObject((String)json, PushPacket.class);
                    if ("dom".equals(pushPacket.type)) {
                        this.hostReactor.processServiceJSON(pushPacket.data);
                        ack = "{\"type\": \"push-ack\", \"lastRefTime\":\"" + pushPacket.lastRefTime + "\", \"data\":\"\"}";
                    } else {
                        ack = "dump".equals(pushPacket.type) ? "{\"type\": \"dump-ack\", \"lastRefTime\": \"" + pushPacket.lastRefTime + "\", \"data\":\"" + StringUtils.escapeJavaScript(JSON.toJSONString(this.hostReactor.getServiceInfoMap())) + "\"}" : "{\"type\": \"unknown-ack\", \"lastRefTime\":\"" + pushPacket.lastRefTime + "\", \"data\":\"\"}";
                    }
                    this.udpSocket.send(new DatagramPacket(ack.getBytes(Charset.forName("UTF-8")), ack.getBytes(Charset.forName("UTF-8")).length, packet.getSocketAddress()));
                }
            }
            catch (Exception e) {
                LogUtils.LOG.error("NA", "error while receiving push data", e);
                continue;
            }
            break;
        }
    }

    public int getUDPPort() {
        return this.udpSocket.getLocalPort();
    }

    public static class PushPacket {
        public String type;
        public long lastRefTime;
        public String data;
    }
}

