/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.config.impl;

import com.alibaba.nacos.client.config.utils.ConcurrentDiskUtil;
import com.alibaba.nacos.client.config.utils.IOUtils;
import com.alibaba.nacos.client.config.utils.JVMUtil;
import com.alibaba.nacos.client.config.utils.SnapShotSwitch;
import com.alibaba.nacos.client.utils.LogUtils;
import com.alibaba.nacos.client.utils.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;

public class LocalConfigInfoProcessor {
    private static final Logger LOGGER = LogUtils.logger(LocalConfigInfoProcessor.class);
    public static final String LOCAL_FILEROOT_PATH = System.getProperty("JM.LOG.PATH", System.getProperty("user.home")) + File.separator + "nacos" + File.separator + "config";
    public static final String LOCAL_SNAPSHOT_PATH = System.getProperty("JM.SNAPSHOT.PATH", System.getProperty("user.home")) + File.separator + "nacos" + File.separator + "config";

    public static String getFailover(String serverName, String dataId, String group, String tenant) {
        File localPath = LocalConfigInfoProcessor.getFailoverFile(serverName, dataId, group, tenant);
        if (!localPath.exists() || !localPath.isFile()) {
            return null;
        }
        try {
            return LocalConfigInfoProcessor.readFile(localPath);
        }
        catch (IOException ioe) {
            LOGGER.error("[" + serverName + "] get failover error, " + localPath, (Throwable)ioe);
            return null;
        }
    }

    public static String getSnapshot(String name, String dataId, String group, String tenant) {
        if (!SnapShotSwitch.getIsSnapShot().booleanValue()) {
            return null;
        }
        File file = LocalConfigInfoProcessor.getSnapshotFile(name, dataId, group, tenant);
        if (!file.exists() || !file.isFile()) {
            return null;
        }
        try {
            return LocalConfigInfoProcessor.readFile(file);
        }
        catch (IOException ioe) {
            LOGGER.error("[" + name + "]+get snapshot error, " + file, (Throwable)ioe);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readFile(File file) throws IOException {
        if (!file.exists() || !file.isFile()) {
            return null;
        }
        if (JVMUtil.isMultiInstance().booleanValue()) {
            return ConcurrentDiskUtil.getFileContent(file, "UTF-8");
        }
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            String string = IOUtils.toString(is, "UTF-8");
            return string;
        }
        finally {
            try {
                if (null != is) {
                    ((InputStream)is).close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static void saveSnapshot(String envName, String dataId, String group, String tenant, String config) {
        if (!SnapShotSwitch.getIsSnapShot().booleanValue()) {
            return;
        }
        File file = LocalConfigInfoProcessor.getSnapshotFile(envName, dataId, group, tenant);
        if (null == config) {
            try {
                IOUtils.delete(file);
            }
            catch (IOException ioe) {
                LOGGER.error("[" + envName + "] delete snapshot error, " + file, (Throwable)ioe);
            }
        } else {
            try {
                boolean isMdOk;
                File parentFile = file.getParentFile();
                if (!parentFile.exists() && !(isMdOk = parentFile.mkdirs())) {
                    LOGGER.error("[{}] save snapshot error", (Object)envName);
                }
                if (JVMUtil.isMultiInstance().booleanValue()) {
                    ConcurrentDiskUtil.writeFileContent(file, config, "UTF-8");
                } else {
                    IOUtils.writeStringToFile(file, config, "UTF-8");
                }
            }
            catch (IOException ioe) {
                LOGGER.error("[" + envName + "] save snapshot error, " + file, (Throwable)ioe);
            }
        }
    }

    public static void cleanAllSnapshot() {
        try {
            File rootFile = new File(LOCAL_SNAPSHOT_PATH);
            File[] files = rootFile.listFiles();
            if (files == null || files.length == 0) {
                return;
            }
            for (File file : files) {
                if (!file.getName().endsWith("_nacos")) continue;
                IOUtils.cleanDirectory(file);
            }
        }
        catch (IOException ioe) {
            LOGGER.error("clean all snapshot error, " + ioe.toString(), (Throwable)ioe);
        }
    }

    public static void cleanEnvSnapshot(String envName) {
        File tmp = new File(LOCAL_SNAPSHOT_PATH, envName + "_nacos");
        tmp = new File(tmp, "snapshot");
        try {
            IOUtils.cleanDirectory(tmp);
            LOGGER.info("success delete " + envName + "-snapshot");
        }
        catch (IOException e) {
            LOGGER.info("fail delete " + envName + "-snapshot, " + e.toString());
            e.printStackTrace();
        }
    }

    static File getFailoverFile(String serverName, String dataId, String group, String tenant) {
        File tmp = new File(LOCAL_SNAPSHOT_PATH, serverName + "_nacos");
        tmp = new File(tmp, "data");
        if (StringUtils.isBlank(tenant)) {
            tmp = new File(tmp, "config-data");
        } else {
            tmp = new File(tmp, "config-data-tenant");
            tmp = new File(tmp, tenant);
        }
        return new File(new File(tmp, group), dataId);
    }

    static File getSnapshotFile(String envName, String dataId, String group, String tenant) {
        File tmp = new File(LOCAL_SNAPSHOT_PATH, envName + "_nacos");
        if (StringUtils.isBlank(tenant)) {
            tmp = new File(tmp, "snapshot");
        } else {
            tmp = new File(tmp, "snapshot-tenant");
            tmp = new File(tmp, tenant);
        }
        return new File(new File(tmp, group), dataId);
    }

    static {
        LOGGER.info("LOCAL_SNAPSHOT_PATH:{}", (Object)LOCAL_SNAPSHOT_PATH);
    }
}

