/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.naming.net;

import com.alibaba.nacos.client.naming.utils.IoUtils;
import com.alibaba.nacos.client.utils.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.apache.commons.lang3.StringUtils;

public class HttpClient {
    public static final int TIME_OUT_MILLIS = Integer.getInteger("com.alibaba.nacos.client.naming.ctimeout", 50000);
    public static final int CON_TIME_OUT_MILLIS = Integer.getInteger("com.alibaba.nacos.client.naming.ctimeout", 3000);
    private static final boolean ENABLE_HTTPS = Boolean.getBoolean("com.alibaba.nacos.client.naming.tls.enable");
    private static final String POST = "POST";
    private static final String PUT = "PUT";

    public static String getPrefix() {
        if (ENABLE_HTTPS) {
            return "https://";
        }
        return "http://";
    }

    public static HttpResult httpGet(String url, List<String> headers, Map<String, String> paramValues, String encoding) {
        return HttpClient.request(url, headers, paramValues, encoding, "GET");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpResult request(String url, List<String> headers, Map<String, String> paramValues, String encoding, String method) {
        HttpURLConnection conn = null;
        try {
            Object b;
            String encodedContent = HttpClient.encodingParams(paramValues, encoding);
            url = url + (StringUtils.isEmpty((CharSequence)encodedContent) ? "" : "?" + encodedContent);
            conn = (HttpURLConnection)new URL(url).openConnection();
            HttpClient.setHeaders(conn, headers, encoding);
            conn.setConnectTimeout(CON_TIME_OUT_MILLIS);
            conn.setReadTimeout(TIME_OUT_MILLIS);
            conn.setRequestMethod(method);
            conn.setDoOutput(true);
            if (POST.equals(method) || PUT.equals(method)) {
                b = encodedContent.getBytes();
                conn.setRequestProperty("Content-Length", String.valueOf(((byte[])b).length));
                conn.getOutputStream().write((byte[])b, 0, ((byte[])b).length);
                conn.getOutputStream().flush();
                conn.getOutputStream().close();
            }
            conn.connect();
            LogUtils.NAMING_LOGGER.debug("Request from server: " + url);
            b = HttpClient.getResult(conn);
            return b;
        }
        catch (Exception e) {
            try {
                if (conn != null) {
                    LogUtils.NAMING_LOGGER.warn("failed to request " + conn.getURL() + " from " + InetAddress.getByName(conn.getURL().getHost()).getHostAddress());
                }
            }
            catch (Exception e1) {
                LogUtils.NAMING_LOGGER.error("[NA] failed to request ", (Throwable)e1);
            }
            LogUtils.NAMING_LOGGER.error("[NA] failed to request ", (Throwable)e);
            HttpResult httpResult = new HttpResult(500, e.toString(), Collections.<String, String>emptyMap());
            return httpResult;
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    private static HttpResult getResult(HttpURLConnection conn) throws IOException {
        int respCode = conn.getResponseCode();
        InputStream inputStream = 200 == respCode || 304 == respCode || 307 == respCode ? conn.getInputStream() : conn.getErrorStream();
        HashMap<String, String> respHeaders = new HashMap<String, String>(conn.getHeaderFields().size());
        for (Map.Entry<String, List<String>> entry : conn.getHeaderFields().entrySet()) {
            respHeaders.put(entry.getKey(), entry.getValue().get(0));
        }
        String encodingGzip = "gzip";
        if (encodingGzip.equals(respHeaders.get("Content-Encoding"))) {
            inputStream = new GZIPInputStream(inputStream);
        }
        return new HttpResult(respCode, IoUtils.toString(inputStream, HttpClient.getCharset(conn)), respHeaders);
    }

    private static String getCharset(HttpURLConnection conn) {
        String contentType = conn.getContentType();
        if (StringUtils.isEmpty((CharSequence)contentType)) {
            return "UTF-8";
        }
        String[] values = contentType.split(";");
        if (values.length == 0) {
            return "UTF-8";
        }
        String charset = "UTF-8";
        for (String value : values) {
            if (!(value = value.trim()).toLowerCase().startsWith("charset=")) continue;
            charset = value.substring("charset=".length());
        }
        return charset;
    }

    private static void setHeaders(HttpURLConnection conn, List<String> headers, String encoding) {
        if (null != headers) {
            Iterator<String> iter = headers.iterator();
            while (iter.hasNext()) {
                conn.addRequestProperty(iter.next(), iter.next());
            }
        }
        conn.addRequestProperty("Content-Type", "application/x-www-form-urlencoded;charset=" + encoding);
        conn.addRequestProperty("Accept-Charset", encoding);
    }

    private static String encodingParams(Map<String, String> params, String encoding) throws UnsupportedEncodingException {
        if (null == params || params.isEmpty()) {
            return "";
        }
        params.put("encoding", encoding);
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            if (StringUtils.isEmpty((CharSequence)entry.getValue())) continue;
            sb.append(entry.getKey()).append("=");
            sb.append(URLEncoder.encode(entry.getValue(), encoding));
            sb.append("&");
        }
        if (sb.length() > 0) {
            sb = sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    static {
        System.setProperty("http.maxRedirects", "5");
    }

    public static class HttpResult {
        public final int code;
        public final String content;
        private final Map<String, String> respHeaders;

        public HttpResult(int code, String content, Map<String, String> respHeaders) {
            this.code = code;
            this.content = content;
            this.respHeaders = respHeaders;
        }

        public String getHeader(String name) {
            return this.respHeaders.get(name);
        }
    }
}

