/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.naming.core;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.listener.Event;
import com.alibaba.nacos.api.naming.listener.EventListener;
import com.alibaba.nacos.api.naming.listener.NamingEvent;
import com.alibaba.nacos.api.naming.pojo.ServiceInfo;
import com.alibaba.nacos.client.naming.utils.CollectionUtils;
import com.alibaba.nacos.client.utils.LogUtils;
import com.alibaba.nacos.common.lifecycle.Closeable;
import com.alibaba.nacos.common.utils.ThreadUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public class EventDispatcher
implements Closeable {
    private ExecutorService executor = null;
    private final BlockingQueue<ServiceInfo> changedServices = new LinkedBlockingQueue<ServiceInfo>();
    private final ConcurrentMap<String, List<EventListener>> observerMap = new ConcurrentHashMap<String, List<EventListener>>();
    private volatile boolean closed = false;

    public EventDispatcher() {
        this.executor = Executors.newSingleThreadExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r, "com.alibaba.nacos.naming.client.listener");
                thread.setDaemon(true);
                return thread;
            }
        });
        this.executor.execute(new Notifier());
    }

    public void addListener(ServiceInfo serviceInfo, String clusters, EventListener listener) {
        LogUtils.NAMING_LOGGER.info("[LISTENER] adding " + serviceInfo.getName() + " with " + clusters + " to listener map");
        List<EventListener> observers = Collections.synchronizedList(new ArrayList());
        observers.add(listener);
        observers = this.observerMap.putIfAbsent(ServiceInfo.getKey((String)serviceInfo.getName(), (String)clusters), observers);
        if (observers != null) {
            observers.add(listener);
        }
        this.serviceChanged(serviceInfo);
    }

    public void removeListener(String serviceName, String clusters, EventListener listener) {
        LogUtils.NAMING_LOGGER.info("[LISTENER] removing " + serviceName + " with " + clusters + " from listener map");
        List observers = (List)this.observerMap.get(ServiceInfo.getKey((String)serviceName, (String)clusters));
        if (observers != null) {
            Iterator iter = observers.iterator();
            while (iter.hasNext()) {
                EventListener oldListener = (EventListener)iter.next();
                if (!oldListener.equals(listener)) continue;
                iter.remove();
            }
            if (observers.isEmpty()) {
                this.observerMap.remove(ServiceInfo.getKey((String)serviceName, (String)clusters));
            }
        }
    }

    public boolean isSubscribed(String serviceName, String clusters) {
        return this.observerMap.containsKey(ServiceInfo.getKey((String)serviceName, (String)clusters));
    }

    public List<ServiceInfo> getSubscribeServices() {
        ArrayList<ServiceInfo> serviceInfos = new ArrayList<ServiceInfo>();
        for (String key : this.observerMap.keySet()) {
            serviceInfos.add(ServiceInfo.fromKey((String)key));
        }
        return serviceInfos;
    }

    public void serviceChanged(ServiceInfo serviceInfo) {
        if (serviceInfo == null) {
            return;
        }
        this.changedServices.add(serviceInfo);
    }

    public void shutdown() throws NacosException {
        String className = this.getClass().getName();
        LogUtils.NAMING_LOGGER.info("{} do shutdown begin", (Object)className);
        ThreadUtils.shutdownThreadPool((ExecutorService)this.executor, (Logger)LogUtils.NAMING_LOGGER);
        this.closed = true;
        LogUtils.NAMING_LOGGER.info("{} do shutdown stop", (Object)className);
    }

    private class Notifier
    implements Runnable {
        private Notifier() {
        }

        @Override
        public void run() {
            while (!EventDispatcher.this.closed) {
                ServiceInfo serviceInfo = null;
                try {
                    serviceInfo = (ServiceInfo)EventDispatcher.this.changedServices.poll(5L, TimeUnit.MINUTES);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (serviceInfo == null) continue;
                try {
                    List listeners = (List)EventDispatcher.this.observerMap.get(serviceInfo.getKey());
                    if (CollectionUtils.isEmpty(listeners)) continue;
                    for (EventListener listener : listeners) {
                        List hosts = Collections.unmodifiableList(serviceInfo.getHosts());
                        listener.onEvent((Event)new NamingEvent(serviceInfo.getName(), serviceInfo.getGroupName(), serviceInfo.getClusters(), hosts));
                    }
                }
                catch (Exception e) {
                    LogUtils.NAMING_LOGGER.error("[NA] notify error for service: " + serviceInfo.getName() + ", clusters: " + serviceInfo.getClusters(), (Throwable)e);
                }
            }
        }
    }
}

