/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.notify;

import com.alibaba.nacos.api.exception.runtime.NacosRuntimeException;
import com.alibaba.nacos.common.JustForTest;
import com.alibaba.nacos.common.notify.DefaultPublisher;
import com.alibaba.nacos.common.notify.DefaultSharePublisher;
import com.alibaba.nacos.common.notify.Event;
import com.alibaba.nacos.common.notify.EventPublisher;
import com.alibaba.nacos.common.notify.SlowEvent;
import com.alibaba.nacos.common.notify.listener.SmartSubscriber;
import com.alibaba.nacos.common.notify.listener.Subscriber;
import com.alibaba.nacos.common.spi.NacosServiceLoader;
import com.alibaba.nacos.common.utils.BiFunction;
import com.alibaba.nacos.common.utils.ClassUtils;
import com.alibaba.nacos.common.utils.MapUtil;
import com.alibaba.nacos.common.utils.ThreadUtils;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotifyCenter {
    private static final Logger LOGGER = LoggerFactory.getLogger(NotifyCenter.class);
    public static int ringBufferSize = 16384;
    public static int shareBufferSize = 1024;
    private static final AtomicBoolean CLOSED = new AtomicBoolean(false);
    private static BiFunction<Class<? extends Event>, Integer, EventPublisher> publisherFactory = null;
    private static final NotifyCenter INSTANCE = new NotifyCenter();
    private DefaultSharePublisher sharePublisher;
    private static Class<? extends EventPublisher> clazz = null;
    private final Map<String, EventPublisher> publisherMap = new ConcurrentHashMap<String, EventPublisher>(16);

    @JustForTest
    public static Map<String, EventPublisher> getPublisherMap() {
        return NotifyCenter.INSTANCE.publisherMap;
    }

    @JustForTest
    public static EventPublisher getPublisher(Class<? extends Event> topic) {
        if (ClassUtils.isAssignableFrom(SlowEvent.class, topic)) {
            return NotifyCenter.INSTANCE.sharePublisher;
        }
        return NotifyCenter.INSTANCE.publisherMap.get(topic.getCanonicalName());
    }

    @JustForTest
    public static EventPublisher getSharePublisher() {
        return NotifyCenter.INSTANCE.sharePublisher;
    }

    public static void shutdown() {
        if (!CLOSED.compareAndSet(false, true)) {
            return;
        }
        LOGGER.warn("[NotifyCenter] Start destroying Publisher");
        for (Map.Entry<String, EventPublisher> entry : NotifyCenter.INSTANCE.publisherMap.entrySet()) {
            try {
                EventPublisher eventPublisher = entry.getValue();
                eventPublisher.shutdown();
            }
            catch (Throwable e) {
                LOGGER.error("[EventPublisher] shutdown has error : {}", e);
            }
        }
        try {
            NotifyCenter.INSTANCE.sharePublisher.shutdown();
        }
        catch (Throwable e) {
            LOGGER.error("[SharePublisher] shutdown has error : {}", e);
        }
        LOGGER.warn("[NotifyCenter] Destruction of the end");
    }

    public static <T> void registerSubscriber(Subscriber consumer) {
        if (consumer instanceof SmartSubscriber) {
            for (Class<? extends Event> subscribeType : ((SmartSubscriber)consumer).subscribeTypes()) {
                if (ClassUtils.isAssignableFrom(SlowEvent.class, subscribeType)) {
                    NotifyCenter.INSTANCE.sharePublisher.addSubscriber(consumer, subscribeType);
                    continue;
                }
                NotifyCenter.addSubscriber(consumer, subscribeType);
            }
            return;
        }
        Class<Event> subscribeType = consumer.subscribeType();
        if (ClassUtils.isAssignableFrom(SlowEvent.class, subscribeType)) {
            NotifyCenter.INSTANCE.sharePublisher.addSubscriber(consumer, subscribeType);
            return;
        }
        NotifyCenter.addSubscriber(consumer, subscribeType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addSubscriber(Subscriber consumer, Class<? extends Event> subscribeType) {
        String topic = ClassUtils.getCanonicalName(subscribeType);
        Class<NotifyCenter> clazz = NotifyCenter.class;
        synchronized (NotifyCenter.class) {
            MapUtil.computeIfAbsent(NotifyCenter.INSTANCE.publisherMap, topic, publisherFactory, subscribeType, ringBufferSize);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            EventPublisher publisher = NotifyCenter.INSTANCE.publisherMap.get(topic);
            publisher.addSubscriber(consumer);
            return;
        }
    }

    public static <T> void deregisterSubscriber(Subscriber consumer) {
        if (consumer instanceof SmartSubscriber) {
            for (Class<? extends Event> subscribeType : ((SmartSubscriber)consumer).subscribeTypes()) {
                if (ClassUtils.isAssignableFrom(SlowEvent.class, subscribeType)) {
                    NotifyCenter.INSTANCE.sharePublisher.removeSubscriber(consumer, subscribeType);
                    continue;
                }
                NotifyCenter.removeSubscriber(consumer, subscribeType);
            }
            return;
        }
        Class<Event> subscribeType = consumer.subscribeType();
        if (ClassUtils.isAssignableFrom(SlowEvent.class, subscribeType)) {
            NotifyCenter.INSTANCE.sharePublisher.removeSubscriber(consumer, subscribeType);
            return;
        }
        if (NotifyCenter.removeSubscriber(consumer, subscribeType)) {
            return;
        }
        throw new NoSuchElementException("The subscriber has no event publisher");
    }

    private static boolean removeSubscriber(Subscriber consumer, Class<? extends Event> subscribeType) {
        String topic = ClassUtils.getCanonicalName(subscribeType);
        EventPublisher eventPublisher = NotifyCenter.INSTANCE.publisherMap.get(topic);
        if (eventPublisher != null) {
            eventPublisher.removeSubscriber(consumer);
            return true;
        }
        return false;
    }

    public static boolean publishEvent(Event event) {
        try {
            return NotifyCenter.publishEvent(event.getClass(), event);
        }
        catch (Throwable ex) {
            LOGGER.error("There was an exception to the message publishing : {}", ex);
            return false;
        }
    }

    private static boolean publishEvent(Class<? extends Event> eventType, Event event) {
        if (ClassUtils.isAssignableFrom(SlowEvent.class, eventType)) {
            return NotifyCenter.INSTANCE.sharePublisher.publish(event);
        }
        String topic = ClassUtils.getCanonicalName(eventType);
        EventPublisher publisher = NotifyCenter.INSTANCE.publisherMap.get(topic);
        if (publisher != null) {
            return publisher.publish(event);
        }
        LOGGER.warn("There are no [{}] publishers for this event, please register", (Object)topic);
        return false;
    }

    public static EventPublisher registerToSharePublisher(Class<? extends SlowEvent> eventType) {
        return NotifyCenter.INSTANCE.sharePublisher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EventPublisher registerToPublisher(Class<? extends Event> eventType, int queueMaxSize) {
        if (ClassUtils.isAssignableFrom(SlowEvent.class, eventType)) {
            return NotifyCenter.INSTANCE.sharePublisher;
        }
        String topic = ClassUtils.getCanonicalName(eventType);
        Class<NotifyCenter> clazz = NotifyCenter.class;
        synchronized (NotifyCenter.class) {
            MapUtil.computeIfAbsent(NotifyCenter.INSTANCE.publisherMap, topic, publisherFactory, eventType, queueMaxSize);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return NotifyCenter.INSTANCE.publisherMap.get(topic);
        }
    }

    public static void deregisterPublisher(Class<? extends Event> eventType) {
        String topic = ClassUtils.getCanonicalName(eventType);
        EventPublisher publisher = NotifyCenter.INSTANCE.publisherMap.remove(topic);
        try {
            publisher.shutdown();
        }
        catch (Throwable ex) {
            LOGGER.error("There was an exception when publisher shutdown : {}", ex);
        }
    }

    static {
        String ringBufferSizeProperty = "nacos.core.notify.ring-buffer-size";
        ringBufferSize = Integer.getInteger(ringBufferSizeProperty, 16384);
        String shareBufferSizeProperty = "nacos.core.notify.share-buffer-size";
        shareBufferSize = Integer.getInteger(shareBufferSizeProperty, 1024);
        Collection<EventPublisher> publishers = NacosServiceLoader.load(EventPublisher.class);
        Iterator<EventPublisher> iterator = publishers.iterator();
        clazz = iterator.hasNext() ? iterator.next().getClass() : DefaultPublisher.class;
        publisherFactory = new BiFunction<Class<? extends Event>, Integer, EventPublisher>(){

            @Override
            public EventPublisher apply(Class<? extends Event> cls, Integer buffer) {
                try {
                    EventPublisher publisher = (EventPublisher)clazz.newInstance();
                    publisher.init(cls, buffer);
                    return publisher;
                }
                catch (Throwable ex) {
                    LOGGER.error("Service class newInstance has error : {}", ex);
                    throw new NacosRuntimeException(500, ex);
                }
            }
        };
        try {
            NotifyCenter.INSTANCE.sharePublisher = new DefaultSharePublisher();
            NotifyCenter.INSTANCE.sharePublisher.init(SlowEvent.class, shareBufferSize);
        }
        catch (Throwable ex) {
            LOGGER.error("Service class newInstance has error : {}", ex);
        }
        ThreadUtils.addShutdownHook(new Runnable(){

            @Override
            public void run() {
                NotifyCenter.shutdown();
            }
        });
    }
}

