/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.remote.client.grpc;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.grpc.auto.Payload;
import com.alibaba.nacos.api.grpc.auto.RequestGrpc;
import com.alibaba.nacos.api.remote.RequestCallBack;
import com.alibaba.nacos.api.remote.RequestFuture;
import com.alibaba.nacos.api.remote.RpcScheduledExecutor;
import com.alibaba.nacos.api.remote.request.Request;
import com.alibaba.nacos.api.remote.response.ErrorResponse;
import com.alibaba.nacos.api.remote.response.Response;
import com.alibaba.nacos.api.remote.response.ResponseCode;
import com.alibaba.nacos.common.remote.client.Connection;
import com.alibaba.nacos.common.remote.client.RpcClient;
import com.alibaba.nacos.common.remote.client.grpc.GrpcUtils;
import com.alibaba.nacos.shaded.com.google.common.util.concurrent.FutureCallback;
import com.alibaba.nacos.shaded.com.google.common.util.concurrent.Futures;
import com.alibaba.nacos.shaded.com.google.common.util.concurrent.ListenableFuture;
import com.alibaba.nacos.shaded.io.grpc.ManagedChannel;
import com.alibaba.nacos.shaded.io.grpc.stub.StreamObserver;
import com.alibaba.nacos.shaded.org.checkerframework.checker.nullness.compatqual.NullableDecl;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class GrpcConnection
extends Connection {
    protected ManagedChannel channel;
    Executor executor;
    protected RequestGrpc.RequestFutureStub grpcFutureServiceStub;
    protected StreamObserver<Payload> payloadStreamObserver;

    public GrpcConnection(RpcClient.ServerInfo serverInfo, Executor executor) {
        super(serverInfo);
        this.executor = executor;
    }

    @Override
    public Response request(Request request, long timeouts) throws NacosException {
        Payload grpcRequest = GrpcUtils.convert(request);
        ListenableFuture<Payload> requestFuture = this.grpcFutureServiceStub.request(grpcRequest);
        Payload grpcResponse = null;
        try {
            grpcResponse = (Payload)requestFuture.get(timeouts, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            throw new NacosException(500, (Throwable)e);
        }
        Response response = (Response)GrpcUtils.parse(grpcResponse);
        return response;
    }

    @Override
    public RequestFuture requestFuture(Request request) throws NacosException {
        Payload grpcRequest = GrpcUtils.convert(request);
        final ListenableFuture<Payload> requestFuture = this.grpcFutureServiceStub.request(grpcRequest);
        return new RequestFuture(){

            @Override
            public boolean isDone() {
                return requestFuture.isDone();
            }

            @Override
            public Response get() throws Exception {
                Payload grpcResponse = (Payload)requestFuture.get();
                Response response = (Response)GrpcUtils.parse(grpcResponse);
                if (response instanceof ErrorResponse) {
                    throw new NacosException(response.getErrorCode(), response.getMessage());
                }
                return response;
            }

            @Override
            public Response get(long timeout) throws Exception {
                Payload grpcResponse = (Payload)requestFuture.get(timeout, TimeUnit.MILLISECONDS);
                Response response = (Response)GrpcUtils.parse(grpcResponse);
                if (response instanceof ErrorResponse) {
                    throw new NacosException(response.getErrorCode(), response.getMessage());
                }
                return response;
            }
        };
    }

    public void sendResponse(Response response) {
        Payload convert = GrpcUtils.convert(response);
        this.payloadStreamObserver.onNext(convert);
    }

    public void sendRequest(Request request) {
        Payload convert = GrpcUtils.convert(request);
        this.payloadStreamObserver.onNext(convert);
    }

    @Override
    public void asyncRequest(Request request, final RequestCallBack requestCallBack) throws NacosException {
        Payload grpcRequest = GrpcUtils.convert(request);
        ListenableFuture<Payload> requestFuture = this.grpcFutureServiceStub.request(grpcRequest);
        Futures.addCallback(requestFuture, new FutureCallback<Payload>(){

            @Override
            public void onSuccess(@NullableDecl Payload grpcResponse) {
                Response response = (Response)GrpcUtils.parse(grpcResponse);
                if (response != null) {
                    if (response instanceof ErrorResponse) {
                        requestCallBack.onException(new NacosException(response.getErrorCode(), response.getMessage()));
                    } else {
                        requestCallBack.onResponse(response);
                    }
                } else {
                    requestCallBack.onException(new NacosException(ResponseCode.FAIL.getCode(), "response is null"));
                }
            }

            @Override
            public void onFailure(Throwable throwable) {
                if (throwable instanceof CancellationException) {
                    requestCallBack.onException(new TimeoutException("Timeout after " + requestCallBack.getTimeout() + " milliseconds."));
                } else {
                    requestCallBack.onException(throwable);
                }
            }
        }, this.executor);
        ListenableFuture<Payload> payloadListenableFuture = Futures.withTimeout(requestFuture, requestCallBack.getTimeout(), TimeUnit.MILLISECONDS, RpcScheduledExecutor.TIMEOUT_SCHEDULER);
    }

    @Override
    public void close() {
        if (this.payloadStreamObserver != null) {
            try {
                this.payloadStreamObserver.onCompleted();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this.channel != null && !this.channel.isShutdown()) {
            try {
                this.channel.shutdownNow();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public ManagedChannel getChannel() {
        return this.channel;
    }

    public void setChannel(ManagedChannel channel) {
        this.channel = channel;
    }

    public RequestGrpc.RequestFutureStub getGrpcFutureServiceStub() {
        return this.grpcFutureServiceStub;
    }

    public void setGrpcFutureServiceStub(RequestGrpc.RequestFutureStub grpcFutureServiceStub) {
        this.grpcFutureServiceStub = grpcFutureServiceStub;
    }

    public StreamObserver<Payload> getPayloadStreamObserver() {
        return this.payloadStreamObserver;
    }

    public void setPayloadStreamObserver(StreamObserver<Payload> payloadStreamObserver) {
        this.payloadStreamObserver = payloadStreamObserver;
    }
}

