/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.shaded.io.grpc.internal;

import com.alibaba.nacos.shaded.com.google.common.annotations.VisibleForTesting;
import com.alibaba.nacos.shaded.com.google.common.base.MoreObjects;
import com.alibaba.nacos.shaded.com.google.common.base.Preconditions;
import com.alibaba.nacos.shaded.com.google.common.util.concurrent.MoreExecutors;
import com.alibaba.nacos.shaded.io.grpc.Attributes;
import com.alibaba.nacos.shaded.io.grpc.CallOptions;
import com.alibaba.nacos.shaded.io.grpc.ClientCall;
import com.alibaba.nacos.shaded.io.grpc.Codec;
import com.alibaba.nacos.shaded.io.grpc.Compressor;
import com.alibaba.nacos.shaded.io.grpc.CompressorRegistry;
import com.alibaba.nacos.shaded.io.grpc.Context;
import com.alibaba.nacos.shaded.io.grpc.Contexts;
import com.alibaba.nacos.shaded.io.grpc.Deadline;
import com.alibaba.nacos.shaded.io.grpc.DecompressorRegistry;
import com.alibaba.nacos.shaded.io.grpc.InternalDecompressorRegistry;
import com.alibaba.nacos.shaded.io.grpc.LoadBalancer;
import com.alibaba.nacos.shaded.io.grpc.Metadata;
import com.alibaba.nacos.shaded.io.grpc.MethodDescriptor;
import com.alibaba.nacos.shaded.io.grpc.Status;
import com.alibaba.nacos.shaded.io.grpc.internal.CallTracer;
import com.alibaba.nacos.shaded.io.grpc.internal.ClientStream;
import com.alibaba.nacos.shaded.io.grpc.internal.ClientStreamListener;
import com.alibaba.nacos.shaded.io.grpc.internal.ClientTransport;
import com.alibaba.nacos.shaded.io.grpc.internal.ContextRunnable;
import com.alibaba.nacos.shaded.io.grpc.internal.FailingClientStream;
import com.alibaba.nacos.shaded.io.grpc.internal.GrpcUtil;
import com.alibaba.nacos.shaded.io.grpc.internal.InsightBuilder;
import com.alibaba.nacos.shaded.io.grpc.internal.LogExceptionRunnable;
import com.alibaba.nacos.shaded.io.grpc.internal.NoopClientStream;
import com.alibaba.nacos.shaded.io.grpc.internal.PickSubchannelArgsImpl;
import com.alibaba.nacos.shaded.io.grpc.internal.RetriableStream;
import com.alibaba.nacos.shaded.io.grpc.internal.SerializeReentrantCallsDirectExecutor;
import com.alibaba.nacos.shaded.io.grpc.internal.SerializingExecutor;
import com.alibaba.nacos.shaded.io.grpc.internal.StreamListener;
import com.alibaba.nacos.shaded.io.perfmark.Link;
import com.alibaba.nacos.shaded.io.perfmark.PerfMark;
import com.alibaba.nacos.shaded.io.perfmark.Tag;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

final class ClientCallImpl<ReqT, RespT>
extends ClientCall<ReqT, RespT> {
    private static final Logger log = Logger.getLogger(ClientCallImpl.class.getName());
    private static final byte[] FULL_STREAM_DECOMPRESSION_ENCODINGS = "gzip".getBytes(Charset.forName("US-ASCII"));
    private final MethodDescriptor<ReqT, RespT> method;
    private final Tag tag;
    private final Executor callExecutor;
    private final CallTracer channelCallsTracer;
    private final Context context;
    private volatile ScheduledFuture<?> deadlineCancellationFuture;
    private final boolean unaryRequest;
    private final CallOptions callOptions;
    private final boolean retryEnabled;
    private ClientStream stream;
    private volatile boolean cancelListenersShouldBeRemoved;
    private boolean cancelCalled;
    private boolean halfCloseCalled;
    private final ClientTransportProvider clientTransportProvider;
    private final Context.CancellationListener cancellationListener = new ContextCancellationListener();
    private final ScheduledExecutorService deadlineCancellationExecutor;
    private boolean fullStreamDecompression;
    private DecompressorRegistry decompressorRegistry = DecompressorRegistry.getDefaultInstance();
    private CompressorRegistry compressorRegistry = CompressorRegistry.getDefaultInstance();

    ClientCallImpl(MethodDescriptor<ReqT, RespT> method, Executor executor, CallOptions callOptions, ClientTransportProvider clientTransportProvider, ScheduledExecutorService deadlineCancellationExecutor, CallTracer channelCallsTracer, boolean retryEnabled) {
        this.method = method;
        this.tag = PerfMark.createTag(method.getFullMethodName(), System.identityHashCode(this));
        this.callExecutor = executor == MoreExecutors.directExecutor() ? new SerializeReentrantCallsDirectExecutor() : new SerializingExecutor(executor);
        this.channelCallsTracer = channelCallsTracer;
        this.context = Context.current();
        this.unaryRequest = method.getType() == MethodDescriptor.MethodType.UNARY || method.getType() == MethodDescriptor.MethodType.SERVER_STREAMING;
        this.callOptions = callOptions;
        this.clientTransportProvider = clientTransportProvider;
        this.deadlineCancellationExecutor = deadlineCancellationExecutor;
        this.retryEnabled = retryEnabled;
        PerfMark.event("ClientCall.<init>", this.tag);
    }

    ClientCallImpl<ReqT, RespT> setFullStreamDecompression(boolean fullStreamDecompression) {
        this.fullStreamDecompression = fullStreamDecompression;
        return this;
    }

    ClientCallImpl<ReqT, RespT> setDecompressorRegistry(DecompressorRegistry decompressorRegistry) {
        this.decompressorRegistry = decompressorRegistry;
        return this;
    }

    ClientCallImpl<ReqT, RespT> setCompressorRegistry(CompressorRegistry compressorRegistry) {
        this.compressorRegistry = compressorRegistry;
        return this;
    }

    @VisibleForTesting
    static void prepareHeaders(Metadata headers, DecompressorRegistry decompressorRegistry, Compressor compressor, boolean fullStreamDecompression) {
        headers.discardAll(GrpcUtil.MESSAGE_ENCODING_KEY);
        if (compressor != Codec.Identity.NONE) {
            headers.put(GrpcUtil.MESSAGE_ENCODING_KEY, compressor.getMessageEncoding());
        }
        headers.discardAll(GrpcUtil.MESSAGE_ACCEPT_ENCODING_KEY);
        byte[] advertisedEncodings = InternalDecompressorRegistry.getRawAdvertisedMessageEncodings(decompressorRegistry);
        if (advertisedEncodings.length != 0) {
            headers.put(GrpcUtil.MESSAGE_ACCEPT_ENCODING_KEY, advertisedEncodings);
        }
        headers.discardAll(GrpcUtil.CONTENT_ENCODING_KEY);
        headers.discardAll(GrpcUtil.CONTENT_ACCEPT_ENCODING_KEY);
        if (fullStreamDecompression) {
            headers.put(GrpcUtil.CONTENT_ACCEPT_ENCODING_KEY, FULL_STREAM_DECOMPRESSION_ENCODINGS);
        }
    }

    @Override
    public void start(ClientCall.Listener<RespT> observer, Metadata headers) {
        PerfMark.startTask("ClientCall.start", this.tag);
        try {
            this.startInternal(observer, headers);
        }
        finally {
            PerfMark.stopTask("ClientCall.start", this.tag);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startInternal(final ClientCall.Listener<RespT> observer, Metadata headers) {
        boolean deadlineExceeded;
        Compressor compressor;
        Preconditions.checkState(this.stream == null, "Already started");
        Preconditions.checkState(!this.cancelCalled, "call was cancelled");
        Preconditions.checkNotNull(observer, "observer");
        Preconditions.checkNotNull(headers, "headers");
        if (this.context.isCancelled()) {
            this.stream = NoopClientStream.INSTANCE;
            class ClosedByContext
            extends ContextRunnable {
                ClosedByContext() {
                    super(ClientCallImpl.this.context);
                }

                @Override
                public void runInContext() {
                    ClientCallImpl.this.closeObserver(observer, Contexts.statusFromCancelled(ClientCallImpl.this.context), new Metadata());
                }
            }
            this.callExecutor.execute(new ClosedByContext());
            return;
        }
        final String compressorName = this.callOptions.getCompressor();
        if (compressorName != null) {
            compressor = this.compressorRegistry.lookupCompressor(compressorName);
            if (compressor == null) {
                this.stream = NoopClientStream.INSTANCE;
                class ClosedByNotFoundCompressor
                extends ContextRunnable {
                    ClosedByNotFoundCompressor() {
                        super(ClientCallImpl.this.context);
                    }

                    @Override
                    public void runInContext() {
                        ClientCallImpl.this.closeObserver(observer, Status.INTERNAL.withDescription(String.format("Unable to find compressor by name %s", compressorName)), new Metadata());
                    }
                }
                this.callExecutor.execute(new ClosedByNotFoundCompressor());
                return;
            }
        } else {
            compressor = Codec.Identity.NONE;
        }
        ClientCallImpl.prepareHeaders(headers, this.decompressorRegistry, compressor, this.fullStreamDecompression);
        Deadline effectiveDeadline = this.effectiveDeadline();
        boolean bl = deadlineExceeded = effectiveDeadline != null && effectiveDeadline.isExpired();
        if (!deadlineExceeded) {
            ClientCallImpl.logIfContextNarrowedTimeout(effectiveDeadline, this.context.getDeadline(), this.callOptions.getDeadline());
            if (this.retryEnabled) {
                this.stream = this.clientTransportProvider.newRetriableStream(this.method, this.callOptions, headers, this.context);
            } else {
                ClientTransport transport = this.clientTransportProvider.get(new PickSubchannelArgsImpl(this.method, headers, this.callOptions));
                Context origContext = this.context.attach();
                try {
                    this.stream = transport.newStream(this.method, headers, this.callOptions);
                }
                finally {
                    this.context.detach(origContext);
                }
            }
        } else {
            this.stream = new FailingClientStream(Status.DEADLINE_EXCEEDED.withDescription("ClientCall started after deadline exceeded: " + effectiveDeadline));
        }
        if (this.callOptions.getAuthority() != null) {
            this.stream.setAuthority(this.callOptions.getAuthority());
        }
        if (this.callOptions.getMaxInboundMessageSize() != null) {
            this.stream.setMaxInboundMessageSize(this.callOptions.getMaxInboundMessageSize());
        }
        if (this.callOptions.getMaxOutboundMessageSize() != null) {
            this.stream.setMaxOutboundMessageSize(this.callOptions.getMaxOutboundMessageSize());
        }
        if (effectiveDeadline != null) {
            this.stream.setDeadline(effectiveDeadline);
        }
        this.stream.setCompressor(compressor);
        if (this.fullStreamDecompression) {
            this.stream.setFullStreamDecompression(this.fullStreamDecompression);
        }
        this.stream.setDecompressorRegistry(this.decompressorRegistry);
        this.channelCallsTracer.reportCallStarted();
        this.stream.start(new ClientStreamListenerImpl(observer));
        this.context.addListener(this.cancellationListener, MoreExecutors.directExecutor());
        if (effectiveDeadline != null && !effectiveDeadline.equals(this.context.getDeadline()) && this.deadlineCancellationExecutor != null) {
            this.deadlineCancellationFuture = this.startDeadlineTimer(effectiveDeadline);
        }
        if (this.cancelListenersShouldBeRemoved) {
            this.removeContextListenerAndCancelDeadlineFuture();
        }
    }

    private static void logIfContextNarrowedTimeout(Deadline effectiveDeadline, @Nullable Deadline outerCallDeadline, @Nullable Deadline callDeadline) {
        if (!log.isLoggable(Level.FINE) || effectiveDeadline == null || !effectiveDeadline.equals(outerCallDeadline)) {
            return;
        }
        long effectiveTimeout = Math.max(0L, effectiveDeadline.timeRemaining(TimeUnit.NANOSECONDS));
        StringBuilder builder = new StringBuilder(String.format("Call timeout set to '%d' ns, due to context deadline.", effectiveTimeout));
        if (callDeadline == null) {
            builder.append(" Explicit call timeout was not set.");
        } else {
            long callTimeout = callDeadline.timeRemaining(TimeUnit.NANOSECONDS);
            builder.append(String.format(" Explicit call timeout was '%d' ns.", callTimeout));
        }
        log.fine(builder.toString());
    }

    private void removeContextListenerAndCancelDeadlineFuture() {
        this.context.removeListener(this.cancellationListener);
        ScheduledFuture<?> f = this.deadlineCancellationFuture;
        if (f != null) {
            f.cancel(false);
        }
    }

    private ScheduledFuture<?> startDeadlineTimer(Deadline deadline) {
        long remainingNanos = deadline.timeRemaining(TimeUnit.NANOSECONDS);
        return this.deadlineCancellationExecutor.schedule(new LogExceptionRunnable(new DeadlineTimer(remainingNanos)), remainingNanos, TimeUnit.NANOSECONDS);
    }

    @Nullable
    private Deadline effectiveDeadline() {
        return ClientCallImpl.min(this.callOptions.getDeadline(), this.context.getDeadline());
    }

    @Nullable
    private static Deadline min(@Nullable Deadline deadline0, @Nullable Deadline deadline1) {
        if (deadline0 == null) {
            return deadline1;
        }
        if (deadline1 == null) {
            return deadline0;
        }
        return deadline0.minimum(deadline1);
    }

    @Override
    public void request(int numMessages) {
        PerfMark.startTask("ClientCall.request", this.tag);
        try {
            Preconditions.checkState(this.stream != null, "Not started");
            Preconditions.checkArgument(numMessages >= 0, "Number requested must be non-negative");
            this.stream.request(numMessages);
        }
        finally {
            PerfMark.stopTask("ClientCall.cancel", this.tag);
        }
    }

    @Override
    public void cancel(@Nullable String message, @Nullable Throwable cause) {
        PerfMark.startTask("ClientCall.cancel", this.tag);
        try {
            this.cancelInternal(message, cause);
        }
        finally {
            PerfMark.stopTask("ClientCall.cancel", this.tag);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelInternal(@Nullable String message, @Nullable Throwable cause) {
        if (message == null && cause == null) {
            cause = new CancellationException("Cancelled without a message or cause");
            log.log(Level.WARNING, "Cancelling without a message or cause is suboptimal", cause);
        }
        if (this.cancelCalled) {
            return;
        }
        this.cancelCalled = true;
        try {
            if (this.stream != null) {
                Status status = Status.CANCELLED;
                status = message != null ? status.withDescription(message) : status.withDescription("Call cancelled without message");
                if (cause != null) {
                    status = status.withCause(cause);
                }
                this.stream.cancel(status);
            }
        }
        finally {
            this.removeContextListenerAndCancelDeadlineFuture();
        }
    }

    @Override
    public void halfClose() {
        PerfMark.startTask("ClientCall.halfClose", this.tag);
        try {
            this.halfCloseInternal();
        }
        finally {
            PerfMark.stopTask("ClientCall.halfClose", this.tag);
        }
    }

    private void halfCloseInternal() {
        Preconditions.checkState(this.stream != null, "Not started");
        Preconditions.checkState(!this.cancelCalled, "call was cancelled");
        Preconditions.checkState(!this.halfCloseCalled, "call already half-closed");
        this.halfCloseCalled = true;
        this.stream.halfClose();
    }

    @Override
    public void sendMessage(ReqT message) {
        PerfMark.startTask("ClientCall.sendMessage", this.tag);
        try {
            this.sendMessageInternal(message);
        }
        finally {
            PerfMark.stopTask("ClientCall.sendMessage", this.tag);
        }
    }

    private void sendMessageInternal(ReqT message) {
        Preconditions.checkState(this.stream != null, "Not started");
        Preconditions.checkState(!this.cancelCalled, "call was cancelled");
        Preconditions.checkState(!this.halfCloseCalled, "call was half-closed");
        try {
            if (this.stream instanceof RetriableStream) {
                RetriableStream retriableStream = (RetriableStream)this.stream;
                retriableStream.sendMessage(message);
            } else {
                this.stream.writeMessage(this.method.streamRequest(message));
            }
        }
        catch (RuntimeException e) {
            this.stream.cancel(Status.CANCELLED.withCause(e).withDescription("Failed to stream message"));
            return;
        }
        catch (Error e) {
            this.stream.cancel(Status.CANCELLED.withDescription("Client sendMessage() failed with Error"));
            throw e;
        }
        if (!this.unaryRequest) {
            this.stream.flush();
        }
    }

    @Override
    public void setMessageCompression(boolean enabled) {
        Preconditions.checkState(this.stream != null, "Not started");
        this.stream.setMessageCompression(enabled);
    }

    @Override
    public boolean isReady() {
        return this.stream.isReady();
    }

    @Override
    public Attributes getAttributes() {
        if (this.stream != null) {
            return this.stream.getAttributes();
        }
        return Attributes.EMPTY;
    }

    private void closeObserver(ClientCall.Listener<RespT> observer, Status status, Metadata trailers) {
        observer.onClose(status, trailers);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("method", this.method).toString();
    }

    private class ClientStreamListenerImpl
    implements ClientStreamListener {
        private final ClientCall.Listener<RespT> observer;
        private boolean closed;

        public ClientStreamListenerImpl(ClientCall.Listener<RespT> observer) {
            this.observer = Preconditions.checkNotNull(observer, "observer");
        }

        @Override
        public void headersRead(final Metadata headers) {
            PerfMark.startTask("ClientStreamListener.headersRead", ClientCallImpl.this.tag);
            final Link link = PerfMark.linkOut();
            try {
                final class HeadersRead
                extends ContextRunnable {
                    HeadersRead() {
                        super(ClientCallImpl.this.context);
                    }

                    @Override
                    public void runInContext() {
                        PerfMark.startTask("ClientCall$Listener.headersRead", ClientCallImpl.this.tag);
                        PerfMark.linkIn(link);
                        try {
                            this.runInternal();
                        }
                        finally {
                            PerfMark.stopTask("ClientCall$Listener.headersRead", ClientCallImpl.this.tag);
                        }
                    }

                    private void runInternal() {
                        if (ClientStreamListenerImpl.this.closed) {
                            return;
                        }
                        try {
                            ClientStreamListenerImpl.this.observer.onHeaders(headers);
                        }
                        catch (Throwable t) {
                            Status status = Status.CANCELLED.withCause(t).withDescription("Failed to read headers");
                            ClientCallImpl.this.stream.cancel(status);
                            ClientStreamListenerImpl.this.close(status, new Metadata());
                        }
                    }
                }
                ClientCallImpl.this.callExecutor.execute(new HeadersRead());
            }
            finally {
                PerfMark.stopTask("ClientStreamListener.headersRead", ClientCallImpl.this.tag);
            }
        }

        @Override
        public void messagesAvailable(final StreamListener.MessageProducer producer) {
            PerfMark.startTask("ClientStreamListener.messagesAvailable", ClientCallImpl.this.tag);
            final Link link = PerfMark.linkOut();
            try {
                final class MessagesAvailable
                extends ContextRunnable {
                    MessagesAvailable() {
                        super(ClientCallImpl.this.context);
                    }

                    @Override
                    public void runInContext() {
                        PerfMark.startTask("ClientCall$Listener.messagesAvailable", ClientCallImpl.this.tag);
                        PerfMark.linkIn(link);
                        try {
                            this.runInternal();
                        }
                        finally {
                            PerfMark.stopTask("ClientCall$Listener.messagesAvailable", ClientCallImpl.this.tag);
                        }
                    }

                    private void runInternal() {
                        if (ClientStreamListenerImpl.this.closed) {
                            GrpcUtil.closeQuietly(producer);
                            return;
                        }
                        try {
                            InputStream message;
                            while ((message = producer.next()) != null) {
                                try {
                                    ClientStreamListenerImpl.this.observer.onMessage(ClientCallImpl.this.method.parseResponse(message));
                                }
                                catch (Throwable t) {
                                    GrpcUtil.closeQuietly(message);
                                    throw t;
                                }
                                message.close();
                            }
                        }
                        catch (Throwable t) {
                            GrpcUtil.closeQuietly(producer);
                            Status status = Status.CANCELLED.withCause(t).withDescription("Failed to read message.");
                            ClientCallImpl.this.stream.cancel(status);
                            ClientStreamListenerImpl.this.close(status, new Metadata());
                        }
                    }
                }
                ClientCallImpl.this.callExecutor.execute(new MessagesAvailable());
            }
            finally {
                PerfMark.stopTask("ClientStreamListener.messagesAvailable", ClientCallImpl.this.tag);
            }
        }

        private void close(Status status, Metadata trailers) {
            this.closed = true;
            ClientCallImpl.this.cancelListenersShouldBeRemoved = true;
            try {
                ClientCallImpl.this.closeObserver(this.observer, status, trailers);
            }
            finally {
                ClientCallImpl.this.removeContextListenerAndCancelDeadlineFuture();
                ClientCallImpl.this.channelCallsTracer.reportCallEnded(status.isOk());
            }
        }

        @Override
        public void closed(Status status, Metadata trailers) {
            this.closed(status, ClientStreamListener.RpcProgress.PROCESSED, trailers);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void closed(Status status, ClientStreamListener.RpcProgress rpcProgress, Metadata trailers) {
            PerfMark.startTask("ClientStreamListener.closed", ClientCallImpl.this.tag);
            try {
                this.closedInternal(status, rpcProgress, trailers);
            }
            finally {
                PerfMark.stopTask("ClientStreamListener.closed", ClientCallImpl.this.tag);
            }
        }

        private void closedInternal(Status status, ClientStreamListener.RpcProgress rpcProgress, Metadata trailers) {
            Deadline deadline = ClientCallImpl.this.effectiveDeadline();
            if (status.getCode() == Status.Code.CANCELLED && deadline != null && deadline.isExpired()) {
                InsightBuilder insight = new InsightBuilder();
                ClientCallImpl.this.stream.appendTimeoutInsight(insight);
                status = Status.DEADLINE_EXCEEDED.augmentDescription("ClientCall was cancelled at or after deadline. " + insight);
                trailers = new Metadata();
            }
            final Status savedStatus = status;
            final Metadata savedTrailers = trailers;
            final Link link = PerfMark.linkOut();
            final class StreamClosed
            extends ContextRunnable {
                StreamClosed() {
                    super(ClientCallImpl.this.context);
                }

                @Override
                public void runInContext() {
                    PerfMark.startTask("ClientCall$Listener.onClose", ClientCallImpl.this.tag);
                    PerfMark.linkIn(link);
                    try {
                        this.runInternal();
                    }
                    finally {
                        PerfMark.stopTask("ClientCall$Listener.onClose", ClientCallImpl.this.tag);
                    }
                }

                private void runInternal() {
                    if (ClientStreamListenerImpl.this.closed) {
                        return;
                    }
                    ClientStreamListenerImpl.this.close(savedStatus, savedTrailers);
                }
            }
            ClientCallImpl.this.callExecutor.execute(new StreamClosed());
        }

        @Override
        public void onReady() {
            if (ClientCallImpl.this.method.getType().clientSendsOneMessage()) {
                return;
            }
            PerfMark.startTask("ClientStreamListener.onReady", ClientCallImpl.this.tag);
            final Link link = PerfMark.linkOut();
            try {
                final class StreamOnReady
                extends ContextRunnable {
                    StreamOnReady() {
                        super(ClientCallImpl.this.context);
                    }

                    @Override
                    public void runInContext() {
                        PerfMark.startTask("ClientCall$Listener.onReady", ClientCallImpl.this.tag);
                        PerfMark.linkIn(link);
                        try {
                            this.runInternal();
                        }
                        finally {
                            PerfMark.stopTask("ClientCall$Listener.onReady", ClientCallImpl.this.tag);
                        }
                    }

                    private void runInternal() {
                        try {
                            ClientStreamListenerImpl.this.observer.onReady();
                        }
                        catch (Throwable t) {
                            Status status = Status.CANCELLED.withCause(t).withDescription("Failed to call onReady.");
                            ClientCallImpl.this.stream.cancel(status);
                            ClientStreamListenerImpl.this.close(status, new Metadata());
                        }
                    }
                }
                ClientCallImpl.this.callExecutor.execute(new StreamOnReady());
            }
            finally {
                PerfMark.stopTask("ClientStreamListener.onReady", ClientCallImpl.this.tag);
            }
        }
    }

    private class DeadlineTimer
    implements Runnable {
        private final long remainingNanos;

        DeadlineTimer(long remainingNanos) {
            this.remainingNanos = remainingNanos;
        }

        @Override
        public void run() {
            InsightBuilder insight = new InsightBuilder();
            ClientCallImpl.this.stream.appendTimeoutInsight(insight);
            ClientCallImpl.this.stream.cancel(Status.DEADLINE_EXCEEDED.augmentDescription("deadline exceeded after " + this.remainingNanos + "ns. " + insight));
        }
    }

    static interface ClientTransportProvider {
        public ClientTransport get(LoadBalancer.PickSubchannelArgs var1);

        public <ReqT> ClientStream newRetriableStream(MethodDescriptor<ReqT, ?> var1, CallOptions var2, Metadata var3, Context var4);
    }

    private final class ContextCancellationListener
    implements Context.CancellationListener {
        private ContextCancellationListener() {
        }

        @Override
        public void cancelled(Context context) {
            ClientCallImpl.this.stream.cancel(Contexts.statusFromCancelled(context));
        }
    }
}

