/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.selector;

import com.alibaba.nacos.client.selector.AbstractSelectorWrapper;
import com.alibaba.nacos.common.utils.CollectionUtils;
import com.alibaba.nacos.common.utils.ConcurrentHashSet;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class SelectorManager<S extends AbstractSelectorWrapper<?, ?, ?>> {
    Map<String, Set<S>> selectorMap = new ConcurrentHashMap<String, Set<S>>();

    public void addSelectorWrapper(String subId, S wrapper) {
        this.selectorMap.compute(subId, (k, v) -> {
            if (v == null) {
                v = new ConcurrentHashSet<AbstractSelectorWrapper>();
            }
            v.add(wrapper);
            return v;
        });
    }

    public Set<S> getSelectorWrappers(String subId) {
        return this.selectorMap.getOrDefault(subId, Collections.emptySet());
    }

    public void removeSelectorWrapper(String subId, S wrapper) {
        this.selectorMap.computeIfPresent(subId, (k, v) -> {
            v.remove(wrapper);
            return v.isEmpty() ? null : v;
        });
    }

    public void removeSubscription(String subId) {
        this.selectorMap.remove(subId);
    }

    public Set<String> getSubscriptions() {
        return this.selectorMap.keySet();
    }

    public boolean isSubscribed(String subId) {
        return CollectionUtils.isNotEmpty(this.getSelectorWrappers(subId));
    }
}

