/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.config.impl;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.client.address.AbstractServerListManager;
import com.alibaba.nacos.client.config.impl.ConfigHttpClientManager;
import com.alibaba.nacos.client.env.NacosClientProperties;
import com.alibaba.nacos.client.utils.LogUtils;
import com.alibaba.nacos.common.http.client.NacosRestTemplate;
import com.alibaba.nacos.common.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.slf4j.Logger;

public class ConfigServerListManager
extends AbstractServerListManager {
    private static final Logger LOGGER = LogUtils.logger(ConfigServerListManager.class);
    private String name;
    private String tenant = "";
    private volatile String currentServerAddr;
    private Iterator<String> iterator;

    public ConfigServerListManager(NacosClientProperties properties) {
        super(properties);
        String namespace = properties.getProperty("namespace");
        if (StringUtils.isNotBlank(namespace)) {
            this.tenant = namespace;
        }
    }

    @Override
    protected String getModuleName() {
        return "Config";
    }

    @Override
    protected NacosRestTemplate getNacosRestTemplate() {
        return ConfigHttpClientManager.getInstance().getNacosRestTemplate();
    }

    @Override
    public void start() throws NacosException {
        super.start();
        this.name = this.initServerName(this.properties);
        this.iterator = this.iterator();
        this.currentServerAddr = this.iterator.next();
    }

    private String initServerName(NacosClientProperties properties) {
        String serverName = properties.containsKey("serverName") ? properties.getProperty("serverName") : this.getServerName();
        serverName = serverName.replaceAll("\\/", "_");
        serverName = serverName.replaceAll("\\:", "_");
        return serverName;
    }

    Iterator<String> iterator() {
        List<String> serverList = this.getServerList();
        if (serverList.isEmpty()) {
            LOGGER.error("[{}] [iterator-serverlist] No server address defined!", (Object)this.name);
        }
        return new ServerAddressIterator(serverList);
    }

    @Override
    public String genNextServer() {
        if (this.iterator == null || !this.iterator.hasNext()) {
            this.refreshCurrentServerAddr();
            return this.currentServerAddr;
        }
        try {
            return this.iterator.next();
        }
        catch (Exception exception) {
            this.refreshCurrentServerAddr();
            return this.currentServerAddr;
        }
    }

    @Override
    public String getCurrentServer() {
        if (StringUtils.isBlank(this.currentServerAddr)) {
            this.iterator = this.iterator();
            this.currentServerAddr = this.iterator.next();
        }
        return this.currentServerAddr;
    }

    public String getUrlString() {
        return this.getServerList().toString();
    }

    public String toString() {
        return "ServerManager-" + this.name + "-" + this.getUrlString();
    }

    public boolean contain(String ip) {
        return this.getServerList().contains(ip);
    }

    public void refreshCurrentServerAddr() {
        this.iterator = this.iterator();
        this.currentServerAddr = this.iterator.next();
    }

    public void updateCurrentServerAddr(String currentServerAddr) {
        this.currentServerAddr = currentServerAddr;
    }

    public Iterator<String> getIterator() {
        return this.iterator;
    }

    public String getName() {
        return this.name;
    }

    public String getTenant() {
        return this.tenant;
    }

    private static class ServerAddressIterator
    implements Iterator<String> {
        final List<RandomizedServerAddress> sorted = new ArrayList<RandomizedServerAddress>();
        final Iterator<RandomizedServerAddress> iter;

        public ServerAddressIterator(List<String> source) {
            for (String address : source) {
                this.sorted.add(new RandomizedServerAddress(address));
            }
            Collections.sort(this.sorted);
            this.iter = this.sorted.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public String next() {
            return this.iter.next().serverIp;
        }

        static class RandomizedServerAddress
        implements Comparable<RandomizedServerAddress> {
            static Random random = new Random();
            String serverIp;
            int seed;

            public RandomizedServerAddress(String ip) {
                this.serverIp = ip;
                this.seed = random.nextInt(Integer.MAX_VALUE);
            }

            @Override
            public int compareTo(RandomizedServerAddress other) {
                return other.seed - this.seed;
            }
        }
    }
}

