/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.util;

import com.alibaba.nacos.common.util.IoUtils;
import com.sun.management.OperatingSystemMXBean;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemUtils {
    private static final Logger logger = LoggerFactory.getLogger(SystemUtils.class);
    public static final String STANDALONE_MODE_PROPERTY_NAME = "nacos.standalone";
    public static final String PREFER_HOSTNAME_OVER_IP_PROPERTY_NAME = "nacos.preferHostnameOverIp";
    public static final boolean PREFER_HOSTNAME_OVER_IP = Boolean.getBoolean("nacos.preferHostnameOverIp");
    public static final boolean STANDALONE_MODE = Boolean.getBoolean("nacos.standalone");
    private static OperatingSystemMXBean operatingSystemMXBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
    public static final String LOCAL_IP = SystemUtils.getHostAddress();
    public static final String NACOS_HOME_KEY = "nacos.home";
    public static final String NACOS_HOME = SystemUtils.getNacosHome();
    public static final String CLUSTER_CONF_FILE_PATH = SystemUtils.getClusterConfFilePath();

    public static List<String> getIPsBySystemEnv(String key) {
        String env = SystemUtils.getSystemEnv(key);
        List<String> ips = new ArrayList<String>();
        if (StringUtils.isNotEmpty((CharSequence)env)) {
            ips = Arrays.asList(env.split(","));
        }
        return ips;
    }

    public static String getSystemEnv(String key) {
        return System.getenv(key);
    }

    public static float getLoad() {
        return (float)operatingSystemMXBean.getSystemLoadAverage();
    }

    public static float getCPU() {
        return (float)operatingSystemMXBean.getSystemCpuLoad();
    }

    public static float getMem() {
        return (float)(1.0 - (double)operatingSystemMXBean.getFreePhysicalMemorySize() / (double)operatingSystemMXBean.getTotalPhysicalMemorySize());
    }

    private static String getHostAddress() {
        String address = System.getProperty("nacos.server.ip");
        if (StringUtils.isNotEmpty((CharSequence)address)) {
            return address;
        }
        address = "127.0.0.1";
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface networkInterface = networkInterfaces.nextElement();
                Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
                while (inetAddresses.hasMoreElements()) {
                    InetAddress ip = inetAddresses.nextElement();
                    if (ip.isLoopbackAddress() || ip.getHostAddress().contains(":")) continue;
                    return ip.getHostAddress();
                }
            }
        }
        catch (Exception e) {
            logger.error("get local host address error", (Throwable)e);
        }
        return address;
    }

    private static String getNacosHome() {
        String nacosHome = System.getProperty(NACOS_HOME_KEY);
        if (StringUtils.isBlank((CharSequence)nacosHome)) {
            nacosHome = System.getProperty("user.home") + File.separator + "nacos";
        }
        return nacosHome;
    }

    public static String getConfFilePath() {
        return NACOS_HOME + File.separator + "conf" + File.separator;
    }

    private static String getClusterConfFilePath() {
        return NACOS_HOME + File.separator + "conf" + File.separator + "cluster.conf";
    }

    public static List<String> readClusterConf() throws IOException {
        ArrayList<String> instanceList = new ArrayList<String>();
        List<String> lines = IoUtils.readLines(new InputStreamReader((InputStream)new FileInputStream(new File(CLUSTER_CONF_FILE_PATH)), "UTF-8"));
        String comment = "#";
        for (String line : lines) {
            String instance = line.trim();
            if (instance.startsWith(comment)) continue;
            if (instance.contains(comment)) {
                instance = instance.substring(0, instance.indexOf(comment));
                instance = instance.trim();
            }
            instanceList.add(instance);
        }
        return instanceList;
    }

    public static void writeClusterConf(String content) throws IOException {
        IoUtils.writeStringToFile(new File(CLUSTER_CONF_FILE_PATH), content, "UTF-8");
    }
}

