/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.http;

import com.alibaba.nacos.common.http.DefaultHttpClientFactory;
import com.alibaba.nacos.common.http.HttpClientFactory;
import com.alibaba.nacos.common.http.HttpClientManager;
import com.alibaba.nacos.common.http.client.NacosAsyncRestTemplate;
import com.alibaba.nacos.common.http.client.NacosRestTemplate;
import com.alibaba.nacos.common.utils.ExceptionUtil;
import com.alibaba.nacos.common.utils.ThreadUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpClientBeanHolder {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpClientManager.class);
    private static final Map<String, NacosRestTemplate> SINGLETON_REST = new HashMap<String, NacosRestTemplate>(10);
    private static final Map<String, NacosAsyncRestTemplate> SINGLETON_ASYNC_REST = new HashMap<String, NacosAsyncRestTemplate>(10);
    private static final AtomicBoolean ALREADY_SHUTDOWN = new AtomicBoolean(false);

    public static NacosRestTemplate getNacosRestTemplate() {
        return HttpClientBeanHolder.getNacosRestTemplate(new DefaultHttpClientFactory());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NacosRestTemplate getNacosRestTemplate(HttpClientFactory httpClientFactory) {
        if (httpClientFactory == null) {
            throw new NullPointerException("httpClientFactory is null");
        }
        String factoryName = httpClientFactory.getClass().getName();
        NacosRestTemplate nacosRestTemplate = SINGLETON_REST.get(factoryName);
        if (nacosRestTemplate == null) {
            Map<String, NacosRestTemplate> map = SINGLETON_REST;
            synchronized (map) {
                nacosRestTemplate = SINGLETON_REST.get(factoryName);
                if (nacosRestTemplate != null) {
                    return nacosRestTemplate;
                }
                nacosRestTemplate = httpClientFactory.createNacosRestTemplate();
                SINGLETON_REST.put(factoryName, nacosRestTemplate);
            }
        }
        return nacosRestTemplate;
    }

    public static NacosAsyncRestTemplate getNacosAsyncRestTemplate() {
        return HttpClientBeanHolder.getNacosAsyncRestTemplate(new DefaultHttpClientFactory());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NacosAsyncRestTemplate getNacosAsyncRestTemplate(HttpClientFactory httpClientFactory) {
        if (httpClientFactory == null) {
            throw new NullPointerException("httpClientFactory is null");
        }
        String factoryName = httpClientFactory.getClass().getName();
        NacosAsyncRestTemplate nacosAsyncRestTemplate = SINGLETON_ASYNC_REST.get(factoryName);
        if (nacosAsyncRestTemplate == null) {
            Map<String, NacosAsyncRestTemplate> map = SINGLETON_ASYNC_REST;
            synchronized (map) {
                nacosAsyncRestTemplate = SINGLETON_ASYNC_REST.get(factoryName);
                if (nacosAsyncRestTemplate != null) {
                    return nacosAsyncRestTemplate;
                }
                nacosAsyncRestTemplate = httpClientFactory.createNacosAsyncRestTemplate();
                SINGLETON_ASYNC_REST.put(factoryName, nacosAsyncRestTemplate);
            }
        }
        return nacosAsyncRestTemplate;
    }

    public static void shutdown() {
        if (!ALREADY_SHUTDOWN.compareAndSet(false, true)) {
            return;
        }
        LOGGER.warn("[HttpClientBeanFactory] Start destroying NacosRestTemplate");
        try {
            HttpClientBeanHolder.nacostRestTemplateShutdown();
            HttpClientBeanHolder.nacosAsyncRestTemplateShutdown();
        }
        catch (Exception ex) {
            LOGGER.error("[HttpClientBeanFactory] An exception occurred when the HTTP client was closed : {}", (Object)ExceptionUtil.getStackTrace(ex));
        }
        LOGGER.warn("[HttpClientBeanFactory] Destruction of the end");
    }

    private static void nacostRestTemplateShutdown() throws Exception {
        if (!SINGLETON_REST.isEmpty()) {
            Collection<NacosRestTemplate> nacosRestTemplates = SINGLETON_REST.values();
            for (NacosRestTemplate nacosRestTemplate : nacosRestTemplates) {
                nacosRestTemplate.close();
            }
            SINGLETON_REST.clear();
        }
    }

    private static void nacosAsyncRestTemplateShutdown() throws Exception {
        if (!SINGLETON_ASYNC_REST.isEmpty()) {
            Collection<NacosAsyncRestTemplate> nacosAsyncRestTemplates = SINGLETON_ASYNC_REST.values();
            for (NacosAsyncRestTemplate nacosAsyncRestTemplate : nacosAsyncRestTemplates) {
                nacosAsyncRestTemplate.close();
            }
            SINGLETON_ASYNC_REST.clear();
        }
    }

    static {
        ThreadUtils.addShutdownHook(new Runnable(){

            @Override
            public void run() {
                HttpClientBeanHolder.shutdown();
            }
        });
    }
}

