/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.http.param;

import com.alibaba.nacos.common.utils.MapUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Header {
    public static final Header EMPTY = Header.newInstance();
    private final Map<String, String> header = new LinkedHashMap<String, String>();
    private final Map<String, List<String>> originalResponseHeader = new LinkedHashMap<String, List<String>>();

    private Header() {
        this.addParam("Content-Type", "application/json;charset=UTF-8");
        this.addParam("Accept-Charset", "UTF-8");
        this.addParam("Accept-Encoding", "gzip");
    }

    public static Header newInstance() {
        return new Header();
    }

    public Header addParam(String key, String value) {
        if (StringUtils.isNotEmpty(key)) {
            this.header.put(key, value);
        }
        return this;
    }

    public Header setContentType(String contentType) {
        if (contentType == null) {
            contentType = "application/json;charset=UTF-8";
        }
        return this.addParam("Content-Type", contentType);
    }

    public Header build() {
        return this;
    }

    public String getValue(String key) {
        return this.header.get(key);
    }

    public Map<String, String> getHeader() {
        return this.header;
    }

    public Iterator<Map.Entry<String, String>> iterator() {
        return this.header.entrySet().iterator();
    }

    public List<String> toList() {
        ArrayList<String> list = new ArrayList<String>(this.header.size() * 2);
        Iterator<Map.Entry<String, String>> iterator = this.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            list.add(entry.getKey());
            list.add(entry.getValue());
        }
        return list;
    }

    public Header addAll(List<String> list) {
        if ((list.size() & 1) != 0) {
            throw new IllegalArgumentException("list size must be a multiple of 2");
        }
        int i = 0;
        while (i < list.size()) {
            String key;
            if (!StringUtils.isNotEmpty(key = list.get(i++))) continue;
            this.header.put(key, list.get(i++));
        }
        return this;
    }

    public void addAll(Map<String, String> params) {
        if (MapUtils.isNotEmpty(params)) {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                this.addParam(entry.getKey(), entry.getValue());
            }
        }
    }

    public void setOriginalResponseHeader(Map<String, List<String>> headers) {
        if (MapUtils.isNotEmpty(headers)) {
            this.originalResponseHeader.putAll(headers);
            for (Map.Entry<String, List<String>> entry : this.originalResponseHeader.entrySet()) {
                this.addParam(entry.getKey(), entry.getValue().get(0));
            }
        }
    }

    public Map<String, List<String>> getOriginalResponseHeader() {
        return this.originalResponseHeader;
    }

    public String getCharset() {
        String acceptCharset = this.getValue("Accept-Charset");
        if (acceptCharset == null) {
            String contentType = this.getValue("Content-Type");
            acceptCharset = StringUtils.isNotBlank(contentType) ? this.analysisCharset(contentType) : "UTF-8";
        }
        return acceptCharset;
    }

    private String analysisCharset(String contentType) {
        String[] values = contentType.split(";");
        String charset = "UTF-8";
        if (values.length == 0) {
            return charset;
        }
        for (String value : values) {
            if (!value.startsWith("charset=")) continue;
            charset = value.substring("charset=".length());
        }
        return charset;
    }

    public void clear() {
        this.header.clear();
        this.originalResponseHeader.clear();
    }

    public String toString() {
        return "Header{headerToMap=" + this.header + '}';
    }
}

