/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.trace.publisher;

import com.alibaba.nacos.common.notify.Event;
import com.alibaba.nacos.common.notify.EventPublisher;
import com.alibaba.nacos.common.notify.EventPublisherFactory;
import com.alibaba.nacos.common.trace.event.TraceEvent;
import com.alibaba.nacos.common.trace.publisher.TraceEventPublisher;
import com.alibaba.nacos.common.utils.ConcurrentHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class TraceEventPublisherFactory
implements EventPublisherFactory {
    private static final TraceEventPublisherFactory INSTANCE = new TraceEventPublisherFactory();
    private final Map<Class<? extends Event>, TraceEventPublisher> publisher = new ConcurrentHashMap<Class<? extends Event>, TraceEventPublisher>();
    private final Set<Class<? extends Event>> publisherEvents = new ConcurrentHashSet<Class<? extends Event>>();

    private TraceEventPublisherFactory() {
    }

    public static TraceEventPublisherFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public EventPublisher apply(Class<? extends Event> eventType, Integer maxQueueSize) {
        Class cachedEventType = TraceEvent.class;
        for (Class<? extends Event> publisherEvent : this.publisherEvents) {
            if (!publisherEvent.isAssignableFrom(eventType)) continue;
            cachedEventType = publisherEvent;
            break;
        }
        this.publisher.computeIfAbsent(cachedEventType, eventClass -> {
            TraceEventPublisher result = new TraceEventPublisher();
            result.init((Class<? extends Event>)eventClass, maxQueueSize);
            return result;
        });
        return this.publisher.get(cachedEventType);
    }

    public String getAllPublisherStatues() {
        StringBuilder result = new StringBuilder("Trace event publisher statues:\n");
        for (TraceEventPublisher each : this.publisher.values()) {
            result.append('\t').append(each.getStatus()).append('\n');
        }
        return result.toString();
    }

    public void addPublisherEvent(Class<? extends Event> event) {
        this.publisherEvents.add(event);
    }
}

