/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.plugin.datasource.impl.derby;

import com.alibaba.nacos.common.utils.CollectionUtils;
import com.alibaba.nacos.common.utils.NamespaceUtil;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.plugin.datasource.impl.derby.AbstractMapperByDerby;
import com.alibaba.nacos.plugin.datasource.mapper.ConfigInfoMapper;
import com.alibaba.nacos.plugin.datasource.model.MapperContext;
import com.alibaba.nacos.plugin.datasource.model.MapperResult;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;

public class ConfigInfoMapperByDerby
extends AbstractMapperByDerby
implements ConfigInfoMapper {
    @Override
    public MapperResult findConfigInfoByAppFetchRows(MapperContext context) {
        String appName = (String)context.getWhereParameter("app_name");
        String tenantId = (String)context.getWhereParameter("tenantId");
        String sql = "SELECT ID,data_id,group_id,tenant_id,app_name,content FROM config_info WHERE tenant_id LIKE ? AND app_name = ? OFFSET " + context.getStartRow() + " ROWS FETCH NEXT " + context.getPageSize() + " ROWS ONLY";
        return new MapperResult(sql, CollectionUtils.list((Object[])new Object[]{tenantId, appName}));
    }

    @Override
    public MapperResult getTenantIdList(MapperContext context) {
        return new MapperResult("SELECT tenant_id FROM config_info WHERE tenant_id != '" + NamespaceUtil.getNamespaceDefaultId() + "' GROUP BY tenant_id OFFSET " + context.getStartRow() + " ROWS FETCH NEXT " + context.getPageSize() + " ROWS ONLY", Collections.emptyList());
    }

    @Override
    public MapperResult getGroupIdList(MapperContext context) {
        return new MapperResult("SELECT group_id FROM config_info WHERE tenant_id ='" + NamespaceUtil.getNamespaceDefaultId() + "' GROUP BY group_id OFFSET " + context.getStartRow() + " ROWS FETCH NEXT " + context.getPageSize() + " ROWS ONLY", Collections.emptyList());
    }

    @Override
    public MapperResult findAllConfigKey(MapperContext context) {
        String sql = " SELECT data_id,group_id,app_name FROM  ( SELECT id FROM config_info WHERE tenant_id LIKE ? ORDER BY id OFFSET " + context.getStartRow() + " ROWS FETCH NEXT " + context.getPageSize() + " ROWS ONLY ) g, config_info t  WHERE g.id = t.id ";
        return new MapperResult(sql, CollectionUtils.list((Object[])new Object[]{context.getWhereParameter("tenantId")}));
    }

    @Override
    public MapperResult findAllConfigInfoBaseFetchRows(MapperContext context) {
        return new MapperResult("SELECT t.id,data_id,group_id,content,md5  FROM ( SELECT id FROM config_info ORDER BY id OFFSET " + context.getStartRow() + " ROWS FETCH NEXT " + context.getPageSize() + " ROWS ONLY )   g, config_info t WHERE g.id = t.id ", Collections.emptyList());
    }

    @Override
    public MapperResult findAllConfigInfoFragment(MapperContext context) {
        String contextParameter = context.getContextParameter("needContent");
        boolean needContent = contextParameter != null && Boolean.parseBoolean(contextParameter);
        return new MapperResult("SELECT id,data_id,group_id,tenant_id,app_name," + (needContent ? "content," : "") + "md5,gmt_modified,type FROM config_info WHERE id > ? ORDER BY id ASC OFFSET " + context.getStartRow() + " ROWS FETCH NEXT " + context.getPageSize() + " ROWS ONLY", CollectionUtils.list((Object[])new Object[]{context.getWhereParameter("id")}));
    }

    @Override
    public MapperResult findChangeConfigFetchRows(MapperContext context) {
        String tenant = (String)context.getWhereParameter("tenant");
        String dataId = (String)context.getWhereParameter("dataId");
        String group = (String)context.getWhereParameter("groupId");
        String appName = (String)context.getWhereParameter("app_name");
        Timestamp startTime = (Timestamp)context.getWhereParameter("startTime");
        Timestamp endTime = (Timestamp)context.getWhereParameter("endTime");
        ArrayList<Object> paramList = new ArrayList<Object>();
        String sqlFetchRows = "SELECT id,data_id,group_id,tenant_id,app_name,content,type,md5,gmt_modified FROM config_info WHERE ";
        String where = " 1=1 ";
        if (!StringUtils.isBlank((CharSequence)dataId)) {
            where = where + " AND data_id LIKE ? ";
            paramList.add(dataId);
        }
        if (!StringUtils.isBlank((CharSequence)group)) {
            where = where + " AND group_id LIKE ? ";
            paramList.add(group);
        }
        if (!StringUtils.isBlank((CharSequence)tenant)) {
            where = where + " AND tenant_id = ? ";
            paramList.add(tenant);
        }
        if (!StringUtils.isBlank((CharSequence)appName)) {
            where = where + " AND app_name = ? ";
            paramList.add(appName);
        }
        if (startTime != null) {
            where = where + " AND gmt_modified >=? ";
            paramList.add(startTime);
        }
        if (endTime != null) {
            where = where + " AND gmt_modified <=? ";
            paramList.add(endTime);
        }
        return new MapperResult("SELECT id,data_id,group_id,tenant_id,app_name,content,type,md5,gmt_modified FROM config_info WHERE " + where + " OFFSET " + context.getStartRow() + " ROWS FETCH NEXT " + context.getPageSize() + " ROWS ONLY", paramList);
    }

    @Override
    public MapperResult listGroupKeyMd5ByPageFetchRows(MapperContext context) {
        return new MapperResult(" SELECT t.id,data_id,group_id,tenant_id,app_name,type,md5,gmt_modified FROM ( SELECT id FROM config_info ORDER BY id OFFSET " + context.getStartRow() + " ROWS FETCH NEXT " + context.getPageSize() + " ROWS ONLY ) g, config_info t WHERE g.id = t.id", Collections.emptyList());
    }

    @Override
    public MapperResult findConfigInfoBaseLikeFetchRows(MapperContext context) {
        String tenant = (String)context.getWhereParameter("tenant");
        String dataId = (String)context.getWhereParameter("dataId");
        String group = (String)context.getWhereParameter("groupId");
        ArrayList<Object> paramList = new ArrayList<Object>();
        String sqlFetchRows = "SELECT id,data_id,group_id,tenant_id,content FROM config_info WHERE ";
        String where = " 1=1 AND tenant_id='" + NamespaceUtil.getNamespaceDefaultId() + "' ";
        if (!StringUtils.isBlank((CharSequence)dataId)) {
            where = where + " AND data_id LIKE ? ";
            paramList.add(dataId);
        }
        if (!StringUtils.isBlank((CharSequence)group)) {
            where = where + " AND group_id LIKE ? ";
            paramList.add(group);
        }
        if (!StringUtils.isBlank((CharSequence)tenant)) {
            where = where + " AND content LIKE ? ";
            paramList.add(tenant);
        }
        return new MapperResult("SELECT id,data_id,group_id,tenant_id,content FROM config_info WHERE " + where + " OFFSET " + context.getStartRow() + " ROWS FETCH NEXT " + context.getPageSize() + " ROWS ONLY", paramList);
    }

    @Override
    public MapperResult findConfigInfo4PageFetchRows(MapperContext context) {
        String tenantId = (String)context.getWhereParameter("tenantId");
        String dataId = (String)context.getWhereParameter("dataId");
        String group = (String)context.getWhereParameter("groupId");
        String appName = (String)context.getWhereParameter("app_name");
        String content = (String)context.getWhereParameter("content");
        ArrayList<Object> paramList = new ArrayList<Object>();
        String sql = "SELECT id,data_id,group_id,tenant_id,app_name,content,type FROM config_info";
        StringBuilder where = new StringBuilder(" WHERE ");
        where.append(" tenant_id=? ");
        paramList.add(tenantId);
        if (StringUtils.isNotBlank((String)dataId)) {
            where.append(" AND data_id=? ");
            paramList.add(dataId);
        }
        if (StringUtils.isNotBlank((String)group)) {
            where.append(" AND group_id=? ");
            paramList.add(group);
        }
        if (StringUtils.isNotBlank((String)appName)) {
            where.append(" AND app_name=? ");
            paramList.add(appName);
        }
        if (!StringUtils.isBlank((CharSequence)content)) {
            where.append(" AND content LIKE ? ");
            paramList.add(content);
        }
        return new MapperResult("SELECT id,data_id,group_id,tenant_id,app_name,content,type FROM config_info" + where + " OFFSET " + context.getStartRow() + " ROWS FETCH NEXT " + context.getPageSize() + " ROWS ONLY", paramList);
    }

    @Override
    public MapperResult findConfigInfoBaseByGroupFetchRows(MapperContext context) {
        return new MapperResult("SELECT id,data_id,group_id,content FROM config_info WHERE group_id=? AND tenant_id=? OFFSET " + context.getStartRow() + " ROWS FETCH NEXT " + context.getPageSize() + " ROWS ONLY", CollectionUtils.list((Object[])new Object[]{context.getWhereParameter("groupId"), context.getWhereParameter("tenantId")}));
    }

    @Override
    public MapperResult findConfigInfoLike4PageFetchRows(MapperContext context) {
        String tenantId = (String)context.getWhereParameter("tenantId");
        String dataId = (String)context.getWhereParameter("dataId");
        String group = (String)context.getWhereParameter("groupId");
        String appName = (String)context.getWhereParameter("app_name");
        String content = (String)context.getWhereParameter("content");
        ArrayList<Object> paramList = new ArrayList<Object>();
        String sqlFetchRows = "SELECT id,data_id,group_id,tenant_id,app_name,content,encrypted_data_key FROM config_info";
        StringBuilder where = new StringBuilder(" WHERE ");
        where.append(" tenant_id LIKE ? ");
        paramList.add(tenantId);
        if (!StringUtils.isBlank((CharSequence)dataId)) {
            where.append(" AND data_id LIKE ? ");
            paramList.add(dataId);
        }
        if (!StringUtils.isBlank((CharSequence)group)) {
            where.append(" AND group_id LIKE ? ");
            paramList.add(group);
        }
        if (!StringUtils.isBlank((CharSequence)appName)) {
            where.append(" AND app_name = ? ");
            paramList.add(appName);
        }
        if (!StringUtils.isBlank((CharSequence)content)) {
            where.append(" AND content LIKE ? ");
            paramList.add(content);
        }
        String sql = "SELECT id,data_id,group_id,tenant_id,app_name,content,encrypted_data_key FROM config_info" + where + " OFFSET " + context.getStartRow() + " ROWS FETCH NEXT " + context.getPageSize() + " ROWS ONLY";
        return new MapperResult(sql, paramList);
    }

    @Override
    public MapperResult findAllConfigInfoFetchRows(MapperContext context) {
        return new MapperResult(" SELECT t.id,data_id,group_id,tenant_id,app_name,content,md5  FROM ( SELECT id FROM config_info  WHERE tenant_id LIKE ? ORDER BY id OFFSET ? ROWS FETCH NEXT ? ROWS ONLY ) g, config_info t  WHERE g.id = t.id ", CollectionUtils.list((Object[])new Object[]{context.getWhereParameter("tenantId"), context.getStartRow(), context.getPageSize()}));
    }

    @Override
    public String getDataSource() {
        return "derby";
    }

    @Override
    public MapperResult findChangeConfig(MapperContext context) {
        String sql = "SELECT id, data_id, group_id, tenant_id, app_name, content, gmt_modified, encrypted_data_key FROM config_info WHERE gmt_modified >= ? and id > ? order by id OFFSET 0 ROWS FETCH NEXT ? ROWS ONLY";
        return new MapperResult(sql, CollectionUtils.list((Object[])new Object[]{context.getWhereParameter("startTime"), context.getWhereParameter("lastMaxId"), context.getWhereParameter("pageSize")}));
    }
}

