/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.plugin.datasource.mapper;

import com.alibaba.nacos.common.utils.CollectionUtils;
import com.alibaba.nacos.plugin.datasource.mapper.Mapper;
import java.util.List;

public abstract class AbstractMapper
implements Mapper {
    @Override
    public String select(List<String> columns, List<String> where) {
        StringBuilder sql = new StringBuilder();
        String method = "SELECT ";
        sql.append(method);
        for (int i = 0; i < columns.size(); ++i) {
            sql.append(columns.get(i));
            if (i == columns.size() - 1) {
                sql.append(" ");
                continue;
            }
            sql.append(",");
        }
        sql.append("FROM ");
        sql.append(this.getTableName());
        sql.append(" ");
        if (CollectionUtils.isEmpty(where)) {
            return sql.toString();
        }
        this.appendWhereClause(where, sql);
        return sql.toString();
    }

    @Override
    public String insert(List<String> columns) {
        int i;
        StringBuilder sql = new StringBuilder();
        String method = "INSERT INTO ";
        sql.append(method);
        sql.append(this.getTableName());
        int size = columns.size();
        sql.append("(");
        for (i = 0; i < size; ++i) {
            sql.append(columns.get(i).split("@")[0]);
            if (i == columns.size() - 1) continue;
            sql.append(", ");
        }
        sql.append(") ");
        sql.append("VALUES");
        sql.append("(");
        for (i = 0; i < size; ++i) {
            String[] parts = columns.get(i).split("@");
            if (parts.length == 2) {
                sql.append(this.getFunction(parts[1]));
            } else {
                sql.append("?");
            }
            if (i == columns.size() - 1) continue;
            sql.append(",");
        }
        sql.append(")");
        return sql.toString();
    }

    @Override
    public String update(List<String> columns, List<String> where) {
        StringBuilder sql = new StringBuilder();
        String method = "UPDATE ";
        sql.append(method);
        sql.append(this.getTableName()).append(" ").append("SET ");
        for (int i = 0; i < columns.size(); ++i) {
            String[] parts = columns.get(i).split("@");
            String column = parts[0];
            if (parts.length == 2) {
                sql.append(column).append(" = ").append(this.getFunction(parts[1]));
            } else {
                sql.append(column).append(" = ").append("?");
            }
            if (i == columns.size() - 1) continue;
            sql.append(",");
        }
        if (CollectionUtils.isEmpty(where)) {
            return sql.toString();
        }
        sql.append(" ");
        this.appendWhereClause(where, sql);
        return sql.toString();
    }

    @Override
    public String delete(List<String> params) {
        StringBuilder sql = new StringBuilder();
        String method = "DELETE ";
        sql.append(method).append("FROM ").append(this.getTableName()).append(" ").append("WHERE ");
        for (int i = 0; i < params.size(); ++i) {
            sql.append(params.get(i)).append(" ").append("=").append(" ? ");
            if (i == params.size() - 1) continue;
            sql.append("AND ");
        }
        return sql.toString();
    }

    @Override
    public String count(List<String> where) {
        StringBuilder sql = new StringBuilder();
        String method = "SELECT ";
        sql.append(method);
        sql.append("COUNT(*) FROM ");
        sql.append(this.getTableName());
        sql.append(" ");
        if (null == where || where.size() == 0) {
            return sql.toString();
        }
        this.appendWhereClause(where, sql);
        return sql.toString();
    }

    @Override
    public String[] getPrimaryKeyGeneratedKeys() {
        return new String[]{"id"};
    }

    private void appendWhereClause(List<String> where, StringBuilder sql) {
        sql.append("WHERE ");
        for (int i = 0; i < where.size(); ++i) {
            sql.append(where.get(i)).append(" = ").append("?");
            if (i == where.size() - 1) continue;
            sql.append(" AND ");
        }
    }
}

