/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.plugin.datasource.impl.derby;

import com.alibaba.nacos.common.utils.CollectionUtils;
import com.alibaba.nacos.common.utils.NamespaceUtil;
import com.alibaba.nacos.plugin.datasource.impl.derby.AbstractMapperByDerby;
import com.alibaba.nacos.plugin.datasource.mapper.GroupCapacityMapper;
import com.alibaba.nacos.plugin.datasource.model.MapperContext;
import com.alibaba.nacos.plugin.datasource.model.MapperResult;
import java.util.ArrayList;
import java.util.Collections;

public class GroupCapacityMapperByDerby
extends AbstractMapperByDerby
implements GroupCapacityMapper {
    @Override
    public String getDataSource() {
        return "derby";
    }

    @Override
    public MapperResult selectGroupInfoBySize(MapperContext context) {
        String sql = "SELECT id, group_id FROM group_capacity WHERE id > ? OFFSET 0 ROWS FETCH NEXT ? ROWS ONLY";
        return new MapperResult(sql, CollectionUtils.list((Object[])new Object[]{context.getWhereParameter("id"), context.getPageSize()}));
    }

    @Override
    public MapperResult select(MapperContext context) {
        String sql = "SELECT id, quota, usage, max_size, max_aggr_count, max_aggr_size, group_id FROM group_capacity WHERE group_id = ?";
        return new MapperResult(sql, Collections.singletonList(context.getWhereParameter("groupId")));
    }

    @Override
    public MapperResult incrementUsageByWhere(MapperContext context) {
        return new MapperResult("UPDATE group_capacity SET usage = usage + 1, gmt_modified = ? WHERE group_id = ?", CollectionUtils.list((Object[])new Object[]{context.getUpdateParameter("gmtModified"), context.getWhereParameter("groupId")}));
    }

    @Override
    public MapperResult incrementUsageByWhereQuotaNotEqualZero(MapperContext context) {
        return new MapperResult("UPDATE group_capacity SET usage = usage + 1, gmt_modified = ? WHERE group_id = ? AND usage < quota AND quota != 0", CollectionUtils.list((Object[])new Object[]{context.getUpdateParameter("gmtModified"), context.getWhereParameter("groupId")}));
    }

    @Override
    public MapperResult insertIntoSelect(MapperContext context) {
        ArrayList<Object> paramList = new ArrayList<Object>();
        paramList.add(context.getUpdateParameter("groupId"));
        paramList.add(context.getUpdateParameter("quota"));
        paramList.add(context.getUpdateParameter("maxSize"));
        paramList.add(context.getUpdateParameter("maxAggrCount"));
        paramList.add(context.getUpdateParameter("maxAggrSize"));
        paramList.add(context.getUpdateParameter("gmtCreate"));
        paramList.add(context.getUpdateParameter("gmtModified"));
        String sql = "INSERT INTO group_capacity (group_id, quota, usage, max_size, max_aggr_count, max_aggr_size,gmt_create, gmt_modified) SELECT ?, ?, count(*), ?, ?, ?, ?, ? FROM config_info";
        return new MapperResult(sql, paramList);
    }

    @Override
    public MapperResult insertIntoSelectByWhere(MapperContext context) {
        String sql = "INSERT INTO group_capacity (group_id, quota, usage, max_size, max_aggr_count, max_aggr_size, gmt_create, gmt_modified) SELECT ?, ?, count(*), ?, ?, ?, ?, ? FROM config_info WHERE group_id=? AND tenant_id = '" + NamespaceUtil.getNamespaceDefaultId() + "'";
        ArrayList<Object> paramList = new ArrayList<Object>();
        paramList.add(context.getUpdateParameter("groupId"));
        paramList.add(context.getUpdateParameter("quota"));
        paramList.add(context.getUpdateParameter("maxSize"));
        paramList.add(context.getUpdateParameter("maxAggrCount"));
        paramList.add(context.getUpdateParameter("maxAggrSize"));
        paramList.add(context.getUpdateParameter("gmtCreate"));
        paramList.add(context.getUpdateParameter("gmtModified"));
        paramList.add(context.getWhereParameter("groupId"));
        return new MapperResult(sql, paramList);
    }

    @Override
    public MapperResult incrementUsageByWhereQuotaEqualZero(MapperContext context) {
        return new MapperResult("UPDATE group_capacity SET usage = usage + 1, gmt_modified = ? WHERE group_id = ? AND usage < ? AND quota = 0", CollectionUtils.list((Object[])new Object[]{context.getUpdateParameter("gmtModified"), context.getWhereParameter("groupId"), context.getWhereParameter("usage")}));
    }

    @Override
    public MapperResult decrementUsageByWhere(MapperContext context) {
        return new MapperResult("UPDATE group_capacity SET usage = usage - 1, gmt_modified = ? WHERE group_id = ? AND usage > 0", CollectionUtils.list((Object[])new Object[]{context.getUpdateParameter("gmtModified"), context.getWhereParameter("groupId")}));
    }

    @Override
    public MapperResult updateUsage(MapperContext context) {
        return new MapperResult("UPDATE group_capacity SET usage = (SELECT count(*) FROM config_info), gmt_modified = ? WHERE group_id = ?", CollectionUtils.list((Object[])new Object[]{context.getUpdateParameter("gmtModified"), context.getWhereParameter("groupId")}));
    }

    @Override
    public MapperResult updateUsageByWhere(MapperContext context) {
        return new MapperResult("UPDATE group_capacity SET usage = (SELECT count(*) FROM config_info WHERE group_id=? AND tenant_id = '" + NamespaceUtil.getNamespaceDefaultId() + "'), gmt_modified = ? WHERE group_id= ?", CollectionUtils.list((Object[])new Object[]{context.getWhereParameter("groupId"), context.getUpdateParameter("gmtModified"), context.getWhereParameter("groupId")}));
    }
}

