/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.maintainer.client.ai;

import com.alibaba.nacos.api.ai.model.mcp.McpEndpointSpec;
import com.alibaba.nacos.api.ai.model.mcp.McpServerBasicInfo;
import com.alibaba.nacos.api.ai.model.mcp.McpServerDetailInfo;
import com.alibaba.nacos.api.ai.model.mcp.McpToolSpecification;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.model.Page;
import com.alibaba.nacos.api.model.v2.ErrorCode;
import com.alibaba.nacos.api.model.v2.Result;
import com.alibaba.nacos.common.http.HttpRestResult;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.maintainer.client.ai.AiMaintainerService;
import com.alibaba.nacos.maintainer.client.model.HttpRequest;
import com.alibaba.nacos.maintainer.client.remote.ClientHttpProxy;
import com.alibaba.nacos.maintainer.client.utils.ParamUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class NacosAiMaintainerServiceImpl
implements AiMaintainerService {
    private final ClientHttpProxy clientHttpProxy;

    public NacosAiMaintainerServiceImpl(Properties properties) throws NacosException {
        this.clientHttpProxy = new ClientHttpProxy(properties);
        ParamUtil.initSerialization();
    }

    @Override
    public Page<McpServerBasicInfo> listMcpServer(String mcpName, int pageNo, int pageSize) throws NacosException {
        HashMap<String, String> params = new HashMap<String, String>(3);
        params.put("pageNo", String.valueOf(pageNo));
        params.put("pageSize", String.valueOf(pageSize));
        params.put("search", "accurate");
        params.put("mcpName", mcpName);
        return this.getMcpServerBasicInfoPage(params);
    }

    @Override
    public Page<McpServerBasicInfo> searchMcpServer(String mcpName, int pageNo, int pageSize) throws NacosException {
        HashMap<String, String> params = new HashMap<String, String>(4);
        params.put("pageNo", String.valueOf(pageNo));
        params.put("pageSize", String.valueOf(pageSize));
        params.put("search", "blur");
        params.put("mcpName", mcpName);
        return this.getMcpServerBasicInfoPage(params);
    }

    private Page<McpServerBasicInfo> getMcpServerBasicInfoPage(Map<String, String> params) throws NacosException {
        HttpRequest httpRequest = new HttpRequest.Builder().setHttpMethod("GET").setPath("/v3/admin/ai/mcp/list").setParamValue(params).build();
        HttpRestResult<String> restResult = this.clientHttpProxy.executeSyncHttpRequest(httpRequest);
        Result result = (Result)JacksonUtils.toObj((String)((String)restResult.getData()), (TypeReference)new TypeReference<Result<Page<McpServerBasicInfo>>>(){});
        return (Page)result.getData();
    }

    @Override
    public McpServerDetailInfo getMcpServerDetail(String mcpName) throws NacosException {
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("mcpName", mcpName);
        HttpRequest httpRequest = new HttpRequest.Builder().setHttpMethod("GET").setPath("/v3/admin/ai/mcp").setParamValue(params).build();
        HttpRestResult<String> restResult = this.clientHttpProxy.executeSyncHttpRequest(httpRequest);
        Result result = (Result)JacksonUtils.toObj((String)((String)restResult.getData()), (TypeReference)new TypeReference<Result<McpServerDetailInfo>>(){});
        return (McpServerDetailInfo)result.getData();
    }

    @Override
    public boolean createMcpServer(String mcpName, McpServerBasicInfo serverSpec, McpToolSpecification toolSpec, McpEndpointSpec endpointSpec) throws NacosException {
        Map<String, String> params = this.buildFullParameters(mcpName, serverSpec, toolSpec, endpointSpec);
        HttpRequest httpRequest = new HttpRequest.Builder().setHttpMethod("POST").setPath("/v3/admin/ai/mcp").setParamValue(params).build();
        HttpRestResult<String> restResult = this.clientHttpProxy.executeSyncHttpRequest(httpRequest);
        Result result = (Result)JacksonUtils.toObj((String)((String)restResult.getData()), (TypeReference)new TypeReference<Result<String>>(){});
        return ErrorCode.SUCCESS.getCode().equals(result.getCode());
    }

    @Override
    public boolean updateMcpServer(String mcpName, McpServerBasicInfo serverSpec, McpToolSpecification toolSpec, McpEndpointSpec endpointSpec) throws NacosException {
        Map<String, String> params = this.buildFullParameters(mcpName, serverSpec, toolSpec, endpointSpec);
        HttpRequest httpRequest = new HttpRequest.Builder().setHttpMethod("PUT").setPath("/v3/admin/ai/mcp").setParamValue(params).build();
        HttpRestResult<String> restResult = this.clientHttpProxy.executeSyncHttpRequest(httpRequest);
        Result result = (Result)JacksonUtils.toObj((String)((String)restResult.getData()), (TypeReference)new TypeReference<Result<String>>(){});
        return ErrorCode.SUCCESS.getCode().equals(result.getCode());
    }

    private Map<String, String> buildFullParameters(String mcpName, McpServerBasicInfo serverSpec, McpToolSpecification toolSpec, McpEndpointSpec endpointSpec) {
        HashMap<String, String> params = new HashMap<String, String>(4);
        params.put("mcpName", mcpName);
        params.put("serverSpecification", JacksonUtils.toJson((Object)serverSpec));
        if (null != toolSpec) {
            params.put("toolSpecification", JacksonUtils.toJson((Object)toolSpec));
        }
        if (null != endpointSpec) {
            params.put("endpointSpecification", JacksonUtils.toJson((Object)endpointSpec));
        }
        return params;
    }

    @Override
    public boolean deleteMcpServer(String mcpName) throws NacosException {
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("mcpName", mcpName);
        HttpRequest httpRequest = new HttpRequest.Builder().setHttpMethod("DELETE").setPath("/v3/admin/ai/mcp").setParamValue(params).build();
        HttpRestResult<String> restResult = this.clientHttpProxy.executeSyncHttpRequest(httpRequest);
        Result result = (Result)JacksonUtils.toObj((String)((String)restResult.getData()), (TypeReference)new TypeReference<Result<String>>(){});
        return ErrorCode.SUCCESS.getCode().equals(result.getCode());
    }
}

