/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.plugin.datasource.ext;

import com.alibaba.nacos.plugin.datasource.enums.mysql.TrustedMysqlFunctionEnum;
import com.alibaba.nacos.plugin.datasource.enums.oracle.TrustedOracleFunctionEnum;
import com.alibaba.nacos.plugin.datasource.enums.oracle.TrustedPostgreSqlFunctionEnum;
import com.alibaba.nacos.plugin.datasource.mapper.AbstractMapper;
import com.alibaba.nacos.plugin.datasource.model.MapperContext;

public abstract class AbstractMapperByExt
extends AbstractMapper {
    public String getFunction(String functionName) {
        String dataSource = this.getDataSource();
        if ("oracle".equals(dataSource)) {
            return TrustedOracleFunctionEnum.getFunctionByName(functionName);
        }
        if ("postgresql".equals(dataSource)) {
            return TrustedPostgreSqlFunctionEnum.getFunctionByName(functionName);
        }
        return TrustedMysqlFunctionEnum.getFunctionByName((String)functionName);
    }

    protected String pageLimit(MapperContext context) {
        String dataSource = this.getDataSource();
        int startRow = context.getStartRow();
        int pageSize = context.getPageSize();
        if ("oracle".equals(dataSource)) {
            return " OFFSET " + startRow + " ROWS FETCH NEXT " + pageSize + " ROWS ONLY";
        }
        if ("postgresql".equals(dataSource)) {
            return " LIMIT " + pageSize + " OFFSET " + startRow;
        }
        return " LIMIT " + startRow + "," + pageSize;
    }

    protected String rowsLimit(Object pageSize) {
        String dataSource = this.getDataSource();
        if ("oracle".equals(dataSource)) {
            return " OFFSET 0 ROWS FETCH NEXT " + pageSize + " ROWS ONLY";
        }
        if ("postgresql".equals(dataSource)) {
            return " LIMIT " + pageSize;
        }
        return " LIMIT " + pageSize;
    }
}

