/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.plugin.datasource.ext;

import com.alibaba.nacos.common.utils.CollectionUtils;
import com.alibaba.nacos.common.utils.NamespaceUtil;
import com.alibaba.nacos.plugin.datasource.ext.AbstractMapperByExt;
import com.alibaba.nacos.plugin.datasource.mapper.GroupCapacityMapper;
import com.alibaba.nacos.plugin.datasource.model.MapperContext;
import com.alibaba.nacos.plugin.datasource.model.MapperResult;
import java.util.ArrayList;
import java.util.Collections;

public abstract class GroupCapacityMapperByExt
extends AbstractMapperByExt
implements GroupCapacityMapper {
    public MapperResult selectGroupInfoBySize(MapperContext context) {
        String sql = "SELECT id, group_id FROM group_capacity WHERE id > ? ORDER BY id" + this.pageLimit(context);
        return new MapperResult(sql, CollectionUtils.list((Object[])new Object[]{context.getWhereParameter("id")}));
    }

    public MapperResult select(MapperContext context) {
        String sql = "SELECT id, quota, usage, max_size, max_aggr_count, max_aggr_size, group_id FROM group_capacity WHERE group_id = ?";
        return new MapperResult(sql, Collections.singletonList(context.getWhereParameter("groupId")));
    }

    public MapperResult insertIntoSelect(MapperContext context) {
        ArrayList<Object> paramList = new ArrayList<Object>();
        paramList.add(context.getUpdateParameter("groupId"));
        paramList.add(context.getUpdateParameter("quota"));
        paramList.add(context.getUpdateParameter("maxSize"));
        paramList.add(context.getUpdateParameter("maxAggrCount"));
        paramList.add(context.getUpdateParameter("maxAggrSize"));
        paramList.add(context.getUpdateParameter("gmtCreate"));
        paramList.add(context.getUpdateParameter("gmtModified"));
        String sql = "INSERT INTO group_capacity (group_id, quota, usage, max_size, max_aggr_count, max_aggr_size,gmt_create, gmt_modified) SELECT ?, ?, count(*), ?, ?, ?, ?, ? FROM config_info";
        return new MapperResult(sql, paramList);
    }

    public MapperResult insertIntoSelectByWhere(MapperContext context) {
        String sql = "INSERT INTO group_capacity (group_id, quota, usage, max_size, max_aggr_count, max_aggr_size, gmt_create, gmt_modified) SELECT ?, ?, count(*), ?, ?, ?, ?, ? FROM config_info WHERE group_id=? AND tenant_id = '" + NamespaceUtil.getNamespaceDefaultId() + "'";
        ArrayList<Object> paramList = new ArrayList<Object>();
        paramList.add(context.getUpdateParameter("groupId"));
        paramList.add(context.getUpdateParameter("quota"));
        paramList.add(context.getUpdateParameter("maxSize"));
        paramList.add(context.getUpdateParameter("maxAggrCount"));
        paramList.add(context.getUpdateParameter("maxAggrSize"));
        paramList.add(context.getUpdateParameter("gmtCreate"));
        paramList.add(context.getUpdateParameter("gmtModified"));
        paramList.add(context.getWhereParameter("groupId"));
        return new MapperResult(sql, paramList);
    }

    public MapperResult incrementUsageByWhereQuotaEqualZero(MapperContext context) {
        return new MapperResult("UPDATE group_capacity SET usage = usage + 1, gmt_modified = ? WHERE group_id = ? AND usage < ? AND quota = 0", CollectionUtils.list((Object[])new Object[]{context.getUpdateParameter("gmtModified"), context.getWhereParameter("groupId"), context.getWhereParameter("usage")}));
    }

    public MapperResult incrementUsageByWhereQuotaNotEqualZero(MapperContext context) {
        return new MapperResult("UPDATE group_capacity SET usage = usage + 1, gmt_modified = ? WHERE group_id = ? AND usage < quota AND quota != 0", CollectionUtils.list((Object[])new Object[]{context.getUpdateParameter("gmtModified"), context.getWhereParameter("groupId")}));
    }

    public MapperResult incrementUsageByWhere(MapperContext context) {
        return new MapperResult("UPDATE group_capacity SET usage = usage + 1, gmt_modified = ? WHERE group_id = ?", CollectionUtils.list((Object[])new Object[]{context.getUpdateParameter("gmtModified"), context.getWhereParameter("groupId")}));
    }

    public MapperResult decrementUsageByWhere(MapperContext context) {
        return new MapperResult("UPDATE group_capacity SET usage = usage - 1, gmt_modified = ? WHERE group_id = ? AND usage > 0", CollectionUtils.list((Object[])new Object[]{context.getUpdateParameter("gmtModified"), context.getWhereParameter("groupId")}));
    }

    public MapperResult updateUsage(MapperContext context) {
        return new MapperResult("UPDATE group_capacity SET usage = (SELECT count(*) FROM config_info), gmt_modified = ? WHERE group_id = ?", CollectionUtils.list((Object[])new Object[]{context.getUpdateParameter("gmtModified"), context.getWhereParameter("groupId")}));
    }

    public MapperResult updateUsageByWhere(MapperContext context) {
        return new MapperResult("UPDATE group_capacity SET usage = (SELECT count(*) FROM config_info WHERE group_id=? AND tenant_id = '" + NamespaceUtil.getNamespaceDefaultId() + "'), gmt_modified = ? WHERE group_id= ?", CollectionUtils.list((Object[])new Object[]{context.getWhereParameter("groupId"), context.getUpdateParameter("gmtModified"), context.getWhereParameter("groupId")}));
    }
}

