/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.plugin.datasource.ext;

import com.alibaba.nacos.common.utils.CollectionUtils;
import com.alibaba.nacos.plugin.datasource.ext.AbstractMapperByExt;
import com.alibaba.nacos.plugin.datasource.mapper.TenantCapacityMapper;
import com.alibaba.nacos.plugin.datasource.model.MapperContext;
import com.alibaba.nacos.plugin.datasource.model.MapperResult;
import java.util.ArrayList;
import java.util.Collections;

public abstract class TenantCapacityMapperByExt
extends AbstractMapperByExt
implements TenantCapacityMapper {
    @Override
    public MapperResult select(MapperContext context) {
        String sql = "SELECT id, quota, usage, max_size, max_aggr_count, max_aggr_size, tenant_id FROM tenant_capacity WHERE tenant_id = ?";
        return new MapperResult(sql, Collections.singletonList(context.getWhereParameter("tenantId")));
    }

    @Override
    public MapperResult getCapacityList4CorrectUsage(MapperContext context) {
        String sql = "SELECT id, tenant_id FROM tenant_capacity WHERE id > ? ORDER BY id " + this.rowsLimit(context.getWhereParameter("limitSize"));
        return new MapperResult(sql, CollectionUtils.list((Object[])new Object[]{context.getWhereParameter("id")}));
    }

    @Override
    public MapperResult incrementUsageWithDefaultQuotaLimit(MapperContext context) {
        return new MapperResult("UPDATE tenant_capacity SET usage = usage + 1, gmt_modified = ? WHERE tenant_id = ? AND usage < ? AND quota = 0", CollectionUtils.list((Object[])new Object[]{context.getUpdateParameter("gmtModified"), context.getWhereParameter("tenantId"), context.getWhereParameter("usage")}));
    }

    @Override
    public MapperResult incrementUsageWithQuotaLimit(MapperContext context) {
        return new MapperResult("UPDATE tenant_capacity SET usage = usage + 1, gmt_modified = ? WHERE tenant_id = ? AND usage < quota AND quota != 0", CollectionUtils.list((Object[])new Object[]{context.getUpdateParameter("gmtModified"), context.getWhereParameter("tenantId")}));
    }

    @Override
    public MapperResult incrementUsage(MapperContext context) {
        return new MapperResult("UPDATE tenant_capacity SET usage = usage + 1, gmt_modified = ? WHERE tenant_id = ?", CollectionUtils.list((Object[])new Object[]{context.getUpdateParameter("gmtModified"), context.getWhereParameter("tenantId")}));
    }

    @Override
    public MapperResult decrementUsage(MapperContext context) {
        return new MapperResult("UPDATE tenant_capacity SET usage = usage - 1, gmt_modified = ? WHERE tenant_id = ? AND usage > 0", CollectionUtils.list((Object[])new Object[]{context.getUpdateParameter("gmtModified"), context.getWhereParameter("tenantId")}));
    }

    @Override
    public MapperResult correctUsage(MapperContext context) {
        return new MapperResult("UPDATE tenant_capacity SET usage = (SELECT count(*) FROM config_info WHERE tenant_id = ?), gmt_modified = ? WHERE tenant_id = ?", CollectionUtils.list((Object[])new Object[]{context.getWhereParameter("tenantId"), context.getUpdateParameter("gmtModified"), context.getWhereParameter("tenantId")}));
    }

    @Override
    public MapperResult insertTenantCapacity(MapperContext context) {
        ArrayList<Object> paramList = new ArrayList<Object>();
        paramList.add(context.getUpdateParameter("tenantId"));
        paramList.add(context.getUpdateParameter("quota"));
        paramList.add(context.getUpdateParameter("maxSize"));
        paramList.add(context.getUpdateParameter("maxAggrCount"));
        paramList.add(context.getUpdateParameter("maxAggrSize"));
        paramList.add(context.getUpdateParameter("gmtCreate"));
        paramList.add(context.getUpdateParameter("gmtModified"));
        paramList.add(context.getWhereParameter("tenantId"));
        return new MapperResult("INSERT INTO tenant_capacity (tenant_id, quota, usage, max_size, max_aggr_count, max_aggr_size, gmt_create, gmt_modified) SELECT ?, ?, count(*), ?, ?, ?, ?, ? FROM config_info WHERE tenant_id=?", paramList);
    }
}

