/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.spring.core.env;

import com.alibaba.nacos.spring.context.event.DeferredApplicationEventPublisher;
import com.alibaba.nacos.spring.context.event.config.NacosConfigMetadataEvent;
import com.alibaba.nacos.spring.core.env.NacosPropertySource;
import com.alibaba.nacos.spring.util.GlobalNacosPropertiesSource;
import com.alibaba.nacos.spring.util.NacosBeanUtils;
import com.alibaba.nacos.spring.util.NacosUtils;
import com.alibaba.nacos.spring.util.config.NacosConfigLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public abstract class AbstractNacosPropertySourceBuilder<T extends BeanDefinition>
implements EnvironmentAware,
BeanFactoryAware,
BeanClassLoaderAware,
ApplicationContextAware,
InitializingBean {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected ConfigurableEnvironment environment;
    protected BeanFactory beanFactory;
    private NacosConfigLoader nacosConfigLoader;
    private Properties globalNacosProperties;
    private final Class<T> beanDefinitionType = com.alibaba.spring.util.ClassUtils.resolveGenericType(this.getClass());
    private ClassLoader classLoader;
    private ApplicationEventPublisher applicationEventPublisher;

    public List<NacosPropertySource> build(String beanName, T beanDefinition) {
        int size;
        Map<String, Object>[] attributesArray = this.resolveRuntimeAttributesArray(beanDefinition, this.globalNacosProperties);
        int n = size = attributesArray == null ? 0 : attributesArray.length;
        if (size == 0) {
            return Collections.emptyList();
        }
        ArrayList<NacosPropertySource> nacosPropertySources = new ArrayList<NacosPropertySource>(size);
        for (int i = 0; i < size; ++i) {
            Map<String, Object> attributes = attributesArray[i];
            if (CollectionUtils.isEmpty(attributes)) continue;
            NacosPropertySource nacosPropertySource = this.doBuild(beanName, beanDefinition, attributesArray[i]);
            NacosConfigMetadataEvent metadataEvent = this.createMetaEvent(nacosPropertySource, beanDefinition);
            this.initMetadataEvent(nacosPropertySource, beanDefinition, metadataEvent);
            this.publishMetadataEvent(metadataEvent);
            nacosPropertySources.add(nacosPropertySource);
        }
        return nacosPropertySources;
    }

    protected abstract NacosConfigMetadataEvent createMetaEvent(NacosPropertySource var1, T var2);

    private void initMetadataEvent(NacosPropertySource nacosPropertySource, T beanDefinition, NacosConfigMetadataEvent metadataEvent) {
        metadataEvent.setDataId(nacosPropertySource.getDataId());
        metadataEvent.setGroupId(nacosPropertySource.getGroupId());
        metadataEvent.setBeanName(nacosPropertySource.getBeanName());
        metadataEvent.setBeanType(nacosPropertySource.getBeanType());
        metadataEvent.setNacosProperties(nacosPropertySource.getProperties());
        Map<String, Object> attributesMetadata = nacosPropertySource.getAttributesMetadata();
        Map nacosPropertiesAttributes = (Map)attributesMetadata.get("properties");
        metadataEvent.setNacosPropertiesAttributes(nacosPropertiesAttributes);
        this.doInitMetadataEvent(nacosPropertySource, beanDefinition, metadataEvent);
    }

    private void publishMetadataEvent(NacosConfigMetadataEvent metadataEvent) {
        this.applicationEventPublisher.publishEvent((ApplicationEvent)metadataEvent);
    }

    protected abstract void doInitMetadataEvent(NacosPropertySource var1, T var2, NacosConfigMetadataEvent var3);

    protected NacosPropertySource doBuild(String beanName, T beanDefinition, Map<String, Object> runtimeAttributes) {
        Map nacosPropertiesAttributes;
        Properties nacosProperties;
        String groupId;
        String name = (String)runtimeAttributes.get("name");
        String dataId = (String)runtimeAttributes.get("dataId");
        String nacosConfig = this.nacosConfigLoader.load(dataId, groupId = (String)runtimeAttributes.get("groupId"), nacosProperties = NacosUtils.resolveProperties(nacosPropertiesAttributes = (Map)runtimeAttributes.get("properties"), (PropertyResolver)this.environment, this.globalNacosProperties));
        if (!StringUtils.hasText((String)nacosConfig) && this.logger.isWarnEnabled()) {
            this.logger.warn(String.format("There is no content for NacosPropertySource from dataId[%s] , groupId[%s] , properties[%s].", dataId, groupId, String.valueOf(nacosPropertiesAttributes)));
        }
        if (!StringUtils.hasText((String)name)) {
            name = NacosUtils.buildDefaultPropertySourceName(dataId, groupId, nacosProperties);
        }
        NacosPropertySource nacosPropertySource = new NacosPropertySource(name, nacosConfig);
        nacosPropertySource.setBeanName(beanName);
        String beanClassName = beanDefinition.getBeanClassName();
        if (StringUtils.hasText((String)beanClassName)) {
            nacosPropertySource.setBeanType(ClassUtils.resolveClassName((String)beanClassName, (ClassLoader)this.classLoader));
        }
        nacosPropertySource.setGroupId(groupId);
        nacosPropertySource.setDataId(dataId);
        nacosPropertySource.setProperties(nacosProperties);
        this.initNacosPropertySource(nacosPropertySource, beanDefinition, runtimeAttributes);
        return nacosPropertySource;
    }

    protected abstract Map<String, Object>[] resolveRuntimeAttributesArray(T var1, Properties var2);

    protected abstract void initNacosPropertySource(NacosPropertySource var1, T var2, Map<String, Object> var3);

    public boolean supports(BeanDefinition beanDefinition) {
        Class<?> beanDefinitionClass = beanDefinition.getClass();
        return this.beanDefinitionType.isAssignableFrom(beanDefinitionClass);
    }

    public void setEnvironment(Environment environment) {
        if (environment instanceof ConfigurableEnvironment) {
            this.environment = (ConfigurableEnvironment)environment;
        }
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        ConfigurableApplicationContext context = (ConfigurableApplicationContext)applicationContext;
        this.applicationEventPublisher = new DeferredApplicationEventPublisher(context);
    }

    public void afterPropertiesSet() throws Exception {
        this.nacosConfigLoader = new NacosConfigLoader(this.environment);
        this.nacosConfigLoader.setNacosServiceFactory(NacosBeanUtils.getNacosServiceFactoryBean(this.beanFactory));
        this.globalNacosProperties = GlobalNacosPropertiesSource.CONFIG.getMergedGlobalProperties(this.beanFactory);
    }

    public final Class<T> getBeanDefinitionType() {
        return this.beanDefinitionType;
    }
}

