/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.p3c.pmd.lang.java.rule.concurrent;

import com.alibaba.p3c.pmd.lang.java.rule.AbstractAliRule;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executors;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTImportDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.lang.java.ast.Token;

public class ThreadPoolCreationRule
extends AbstractAliRule {
    private static final String DOT = ".";
    private static final String COLON = ";";
    private static final String NEW = "new";
    private static final String EXECUTORS_NEW = Executors.class.getSimpleName() + "." + "new";
    private static final String FULL_EXECUTORS_NEW = Executors.class.getName() + "." + "new";
    private static final String BRACKETS = "()";

    @Override
    public Object visit(ASTCompilationUnit node, Object data) {
        Object superResult = super.visit(node, data);
        Info info = new Info();
        List importDeclarations = node.findChildrenOfType(ASTImportDeclaration.class);
        for (ASTImportDeclaration importDeclaration : importDeclarations) {
            ASTName name = (ASTName)importDeclaration.getFirstChildOfType(ASTName.class);
            boolean bl = info.executorsUsed = info.executorsUsed || name.getType() == Executors.class || Executors.class.getName().equals(name.getImage());
            if (!name.getImage().startsWith(Executors.class.getName() + DOT)) continue;
            info.importedExecutorsMethods.add(name.getImage());
        }
        List primaryExpressions = node.findDescendantsOfType(ASTPrimaryExpression.class);
        for (ASTPrimaryExpression primaryExpression : primaryExpressions) {
            Token initToken;
            if (!info.executorsUsed && info.importedExecutorsMethods.isEmpty() || this.checkInitStatement(initToken = (Token)primaryExpression.jjtGetFirstToken(), info)) continue;
            this.addViolationWithMessage(data, (Node)primaryExpression, "java.concurrent.ThreadPoolCreationRule.violation.msg");
        }
        return superResult;
    }

    private boolean checkInitStatement(Token token, Info info) {
        String fullAssignStatement = this.getFullAssignStatement(token);
        if (fullAssignStatement.startsWith(EXECUTORS_NEW)) {
            return false;
        }
        if (!fullAssignStatement.startsWith(NEW) && !fullAssignStatement.startsWith(FULL_EXECUTORS_NEW)) {
            return true;
        }
        int index = fullAssignStatement.indexOf(BRACKETS);
        if (index == -1) {
            return true;
        }
        if (info.importedExecutorsMethods.contains(fullAssignStatement = fullAssignStatement.substring(0, index))) {
            return false;
        }
        return !info.importedExecutorsMethods.contains(Executors.class.getName() + DOT + fullAssignStatement);
    }

    private String getFullAssignStatement(Token token) {
        if (token == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder(48);
        Token next = token;
        while (next.next != null && !COLON.equals(next.image)) {
            sb.append(next.image);
            next = next.next;
        }
        return sb.toString();
    }

    class Info {
        boolean executorsUsed;
        Set<String> importedExecutorsMethods = new HashSet<String>();

        Info() {
        }
    }
}

