/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.p3c.pmd.lang.java.rule.naming;

import com.alibaba.p3c.pmd.I18nResources;
import com.alibaba.p3c.pmd.lang.java.rule.AbstractAliRule;
import com.alibaba.p3c.pmd.lang.java.util.ViolationUtils;
import com.alibaba.p3c.pmd.lang.java.util.namelist.NameListConfig;
import java.util.HashSet;
import java.util.Set;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.rule.AbstractRule;
import org.apache.commons.lang3.StringUtils;

public class ConstantFieldShouldBeUpperCaseRule
extends AbstractAliRule {
    private static final String SERVICE_SUFFIX = "Service";
    private static final Set<String> LOG_VARIABLE_TYPE_SET = new HashSet<String>(NameListConfig.NAME_LIST_SERVICE.getNameList("ConstantFieldShouldBeUpperCaseRule", "LOG_VARIABLE_TYPE_SET"));
    private static final Set<String> WHITE_LIST = new HashSet<String>(NameListConfig.NAME_LIST_SERVICE.getNameList("ConstantFieldShouldBeUpperCaseRule", "WHITE_LIST"));

    public Object visit(ASTFieldDeclaration node, Object data) {
        boolean inWhiteList;
        if (!node.isStatic() || !node.isFinal()) {
            return super.visit(node, data);
        }
        ASTClassOrInterfaceType classOrInterfaceType = (ASTClassOrInterfaceType)node.getFirstDescendantOfType(ASTClassOrInterfaceType.class);
        if (classOrInterfaceType != null && LOG_VARIABLE_TYPE_SET.contains(classOrInterfaceType.getImage())) {
            return super.visit(node, data);
        }
        String constantName = node.jjtGetChild(1).jjtGetChild(0).getImage();
        boolean bl = inWhiteList = StringUtils.isEmpty((CharSequence)constantName) || WHITE_LIST.contains(constantName) || constantName.endsWith(SERVICE_SUFFIX);
        if (inWhiteList) {
            return super.visit(node, data);
        }
        if (!constantName.equals(constantName.toUpperCase())) {
            ViolationUtils.addViolationWithPrecisePosition((AbstractRule)this, (Node)node, data, I18nResources.getMessage("java.naming.ConstantFieldShouldBeUpperCaseRule.violation.msg", constantName));
        }
        return super.visit(node, data);
    }
}

