/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.p3c.pmd.lang.java.rule.naming;

import com.alibaba.p3c.pmd.I18nResources;
import com.alibaba.p3c.pmd.lang.java.rule.AbstractAliRule;
import com.alibaba.p3c.pmd.lang.java.util.ViolationUtils;
import java.util.regex.Pattern;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclarator;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.lang.rule.AbstractRule;

public class LowerCamelCaseVariableNamingRule
extends AbstractAliRule {
    private static final String MESSAGE_KEY_PREFIX = "java.naming.LowerCamelCaseVariableNamingRule.violation.msg";
    private Pattern pattern = Pattern.compile("^[a-z|$][a-z0-9]*([A-Z][a-z0-9]*)*(DO|DTO|VO|DAO)?$");

    public Object visit(ASTVariableDeclaratorId node, Object data) {
        boolean isNotCheck;
        ASTFieldDeclaration astFieldDeclaration = (ASTFieldDeclaration)node.getFirstParentOfType(ASTFieldDeclaration.class);
        boolean bl = isNotCheck = astFieldDeclaration != null && (astFieldDeclaration.isFinal() || astFieldDeclaration.isStatic());
        if (isNotCheck) {
            return super.visit(node, data);
        }
        if (!this.pattern.matcher(node.getImage()).matches()) {
            ViolationUtils.addViolationWithPrecisePosition((AbstractRule)this, (Node)node, data, I18nResources.getMessage("java.naming.LowerCamelCaseVariableNamingRule.violation.msg.variable", node.getImage()));
        }
        return super.visit(node, data);
    }

    public Object visit(ASTMethodDeclarator node, Object data) {
        if (!this.pattern.matcher(node.getImage()).matches()) {
            ViolationUtils.addViolationWithPrecisePosition((AbstractRule)this, (Node)node, data, I18nResources.getMessage("java.naming.LowerCamelCaseVariableNamingRule.violation.msg.method", node.getImage()));
        }
        return super.visit(node, data);
    }
}

