/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.p3c.pmd.lang.java.util.namelist;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.p3c.pmd.lang.java.util.namelist.NameListService;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class NameListServiceImpl
implements NameListService {
    private static final String NAME_LIST_PROPERTY_FILE_NAME = "namelist.properties";
    private static final Properties PROPERTIES = NameListServiceImpl.initProperties();
    private static final String SEPARATOR = "_";

    private static Properties initProperties() {
        LinkedProperties props = new LinkedProperties();
        ClassLoader classLoader = NameListServiceImpl.class.getClassLoader();
        try {
            props.load(classLoader.getResourceAsStream(NAME_LIST_PROPERTY_FILE_NAME));
        }
        catch (IOException ex) {
            throw new IllegalStateException("Load namelist.properties fail", ex);
        }
        return props;
    }

    @Override
    public List<String> getNameList(String className, String name) {
        return JSON.parseArray((String)((String)PROPERTIES.get(className + SEPARATOR + name)), String.class);
    }

    @Override
    public <K, V> Map<K, V> getNameMap(String className, String name, Class<K> kClass, Class<V> vClass) {
        return (Map)JSON.parseObject((String)((String)PROPERTIES.get(className + SEPARATOR + name)), (TypeReference)new TypeReference<Map<K, V>>(new Type[]{kClass, vClass}){}, (Feature[])new Feature[0]);
    }

    private static class LinkedProperties
    extends Properties {
        private LinkedHashSet<Object> linkedKeys = new LinkedHashSet();

        private LinkedProperties() {
        }

        @Override
        public Object put(Object key, Object value) {
            this.linkedKeys.add(key);
            return super.put(key, value);
        }

        public int getSize() {
            return this.linkedKeys.size();
        }
    }
}

