/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.p3c.pmd.lang.java.rule.concurrent;

import com.alibaba.p3c.pmd.lang.java.rule.AbstractAliRule;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAllocationExpression;
import net.sourceforge.pmd.lang.java.ast.ASTArgumentList;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTLambdaExpression;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;

public class ThreadShouldSetNameRule
extends AbstractAliRule {
    private static final int ARGUMENT_LENGTH_2 = 2;
    private static final int ARGUMENT_LENGTH_6 = 6;
    private static final int INDEX_1 = 1;
    private static final int SINGLE_LENGTH = 1;
    private static final String MESSAGE_KEY_PREFIX = "java.concurrent.ThreadShouldSetNameRule.violation.msg";

    public Object visit(ASTAllocationExpression node, Object data) {
        if (node.getType() == null) {
            return super.visit(node, data);
        }
        if (!ExecutorService.class.isAssignableFrom(node.getType())) {
            return super.visit(node, data);
        }
        if (ThreadPoolExecutor.class == node.getType()) {
            return this.checkThreadPoolExecutor(node, data);
        }
        if (ScheduledThreadPoolExecutor.class == node.getType()) {
            return this.checkSchedulePoolExecutor(node, data);
        }
        return super.visit(node, data);
    }

    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        return super.visit(node, data);
    }

    private Object checkThreadPoolExecutor(ASTAllocationExpression node, Object data) {
        ASTArgumentList argumentList = (ASTArgumentList)node.getFirstDescendantOfType(ASTArgumentList.class);
        if (argumentList.jjtGetNumChildren() < 6 || !this.checkThreadFactoryArgument((ASTExpression)argumentList.jjtGetChild(5))) {
            this.addViolationWithMessage(data, (Node)node, "java.concurrent.ThreadShouldSetNameRule.violation.msg.ThreadPoolExecutor");
        }
        return super.visit(node, data);
    }

    private Object checkSchedulePoolExecutor(ASTAllocationExpression node, Object data) {
        ASTArgumentList argumentList = (ASTArgumentList)node.getFirstDescendantOfType(ASTArgumentList.class);
        if (argumentList.jjtGetNumChildren() < 2 || !this.checkThreadFactoryArgument((ASTExpression)argumentList.jjtGetChild(1))) {
            this.addViolationWithMessage(data, (Node)node, "java.concurrent.ThreadShouldSetNameRule.violation.msg.ScheduledThreadPoolExecutor");
        }
        return super.visit(node, data);
    }

    private boolean checkThreadFactoryArgument(ASTExpression expression) {
        List variableDeclaratorIds;
        if (expression.getType() != null && ThreadFactory.class.isAssignableFrom(expression.getType())) {
            return true;
        }
        ASTName name = (ASTName)expression.getFirstDescendantOfType(ASTName.class);
        if (name != null && name.getType() == Executors.class) {
            return false;
        }
        ASTLambdaExpression lambdaExpression = (ASTLambdaExpression)expression.getFirstDescendantOfType(ASTLambdaExpression.class);
        return !(lambdaExpression != null ? (variableDeclaratorIds = lambdaExpression.findChildrenOfType(ASTVariableDeclaratorId.class)) == null || variableDeclaratorIds.size() != 1 : expression.getType() != null && RejectedExecutionHandler.class.isAssignableFrom(expression.getType()));
    }
}

