/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.p3c.pmd.lang.java.rule.naming;

import com.alibaba.p3c.pmd.I18nResources;
import com.alibaba.p3c.pmd.lang.java.rule.AbstractAliRule;
import com.alibaba.p3c.pmd.lang.java.util.ViolationUtils;
import com.alibaba.p3c.pmd.lang.java.util.namelist.NameListConfig;
import java.util.List;
import java.util.regex.Pattern;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.rule.AbstractRule;

public class ClassNamingShouldBeCamelRule
extends AbstractAliRule {
    private static final Pattern PATTERN = Pattern.compile("^I?([A-Z][a-z0-9]+)+(([A-Z])|(DO|DTO|VO|DAO|BO|DAOImpl|YunOS|AO|PO))?$");
    private static final List<String> CLASS_NAMING_WHITE_LIST = NameListConfig.NAME_LIST_SERVICE.getNameList(ClassNamingShouldBeCamelRule.class.getSimpleName(), "CLASS_NAMING_WHITE_LIST");

    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        for (String s : CLASS_NAMING_WHITE_LIST) {
            if (!node.getImage().contains(s)) continue;
            return super.visit(node, data);
        }
        if (PATTERN.matcher(node.getImage()).matches()) {
            return super.visit(node, data);
        }
        ViolationUtils.addViolationWithPrecisePosition((AbstractRule)this, (Node)node, data, I18nResources.getMessage("java.naming.ClassNamingShouldBeCamelRule.violation.msg", node.getImage()));
        return super.visit(node, data);
    }
}

