/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.p3c.pmd.lang.java.rule.oop;

import com.alibaba.p3c.pmd.lang.java.rule.AbstractPojoRule;
import java.util.List;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTType;
import org.jaxen.JaxenException;

public class PojoMustUsePrimitiveFieldRule
extends AbstractPojoRule {
    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        if (!this.isPojo(node)) {
            return super.visit(node, data);
        }
        try {
            List fields = node.findChildNodesWithXPath("ClassOrInterfaceBody/ClassOrInterfaceBodyDeclaration/FieldDeclaration");
            for (Node fieldNode : fields) {
                Class type;
                ASTFieldDeclaration field = (ASTFieldDeclaration)fieldNode;
                boolean shouldProcess = !field.isPublic() && !field.isStatic() && !field.isTransient();
                if (!shouldProcess || (type = field.getType()) == null || !type.isPrimitive()) continue;
                this.addViolationWithMessage(data, (Node)field.getFirstDescendantOfType(ASTType.class), "java.oop.PojoMustUsePrimitiveFieldRule.violation.msg", new Object[]{field.getVariableName()});
            }
        }
        catch (JaxenException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return super.visit(node, data);
    }
}

