/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.p3c.pmd.lang.java.util;

import java.util.List;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTImportDeclaration;

public class GeneratedCodeUtils {
    private static final String ANNOTATION_NAME = "javax.annotation.Generated";
    private static final String CLASS = "class";

    public static boolean isGenerated(ASTCompilationUnit compilationUnit) {
        List importDeclarationList = compilationUnit.findChildrenOfType(ASTImportDeclaration.class);
        if (importDeclarationList.isEmpty()) {
            return false;
        }
        for (ASTImportDeclaration importDeclaration : importDeclarationList) {
            if (!ANNOTATION_NAME.equals(importDeclaration.getImportedName())) continue;
            return true;
        }
        return false;
    }

    public static boolean isGenerated(String content) {
        int classIndex = content.indexOf(CLASS);
        if (classIndex <= 1) {
            return false;
        }
        String importHeader = content.substring(0, classIndex);
        return importHeader.contains(ANNOTATION_NAME);
    }
}

