/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.spring.web.method;

import com.alibaba.spring.web.servlet.mvc.util.WebMvcUtils;
import com.alibaba.spring.web.util.WebUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerExecutionChain;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public class HandlerMethodResolver {
    private static final String HANDLER_METHOD_ATTRIBUTE_NAME = HandlerMethod.class.getName();

    public Collection<HandlerMethod> resolveHandlerMethods(HttpServletRequest request, ServletContext servletContext) throws IllegalStateException {
        WebApplicationContext webApplicationContext = WebMvcUtils.getWebApplicationContext(request, servletContext);
        Collection requestMappingHandlerMappings = webApplicationContext.getBeansOfType(RequestMappingHandlerMapping.class).values();
        LinkedList handlerMethods = new LinkedList();
        for (RequestMappingHandlerMapping requestMappingHandlerMapping : requestMappingHandlerMappings) {
            handlerMethods.addAll(requestMappingHandlerMapping.getHandlerMethods().values());
        }
        return Collections.unmodifiableCollection(handlerMethods);
    }

    public Collection<HandlerMethod> resolveHandlerMethods(HttpServletRequest request) throws IllegalStateException {
        return this.resolveHandlerMethods(request, WebUtils.getServletContext(request));
    }

    public HandlerMethod resolveHandlerMethod(HttpServletRequest request, ServletContext servletContext) throws IllegalStateException {
        HandlerMethod handlerMethod = (HandlerMethod)request.getAttribute(HANDLER_METHOD_ATTRIBUTE_NAME);
        if (handlerMethod == null) {
            RequestMappingHandlerMapping handlerMapping = WebMvcUtils.getRequestMappingHandlerMapping(request, servletContext);
            try {
                Object handler;
                HandlerExecutionChain handlerExecutionChain = handlerMapping.getHandler(request);
                Object object = handler = handlerExecutionChain == null ? null : handlerExecutionChain.getHandler();
                if (handler instanceof HandlerMethod) {
                    handlerMethod = (HandlerMethod)handler;
                    request.setAttribute(HANDLER_METHOD_ATTRIBUTE_NAME, (Object)handlerMethod);
                }
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        return handlerMethod;
    }

    public HandlerMethod resolveHandlerMethod(HttpServletRequest request) throws IllegalStateException {
        return this.resolveHandlerMethod(request, WebUtils.getServletContext(request));
    }
}

