/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl;

import com.alibaba.ttl.TtlCopier;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.ParametersAreNonnullByDefault;

public class TransmittableThreadLocal<T>
extends InheritableThreadLocal<T>
implements TtlCopier<T> {
    private static final Logger logger = Logger.getLogger(TransmittableThreadLocal.class.getName());
    private final boolean disableIgnoreNullValueSemantics;
    private static final InheritableThreadLocal<WeakHashMap<TransmittableThreadLocal<Object>, ?>> holder = new InheritableThreadLocal<WeakHashMap<TransmittableThreadLocal<Object>, ?>>(){

        @Override
        protected WeakHashMap<TransmittableThreadLocal<Object>, ?> initialValue() {
            return new WeakHashMap();
        }

        @Override
        protected WeakHashMap<TransmittableThreadLocal<Object>, ?> childValue(WeakHashMap<TransmittableThreadLocal<Object>, ?> parentValue) {
            return new WeakHashMap(parentValue);
        }
    };

    public TransmittableThreadLocal() {
        this(false);
    }

    public TransmittableThreadLocal(boolean disableIgnoreNullValueSemantics) {
        this.disableIgnoreNullValueSemantics = disableIgnoreNullValueSemantics;
    }

    @NonNull
    public static <S> TransmittableThreadLocal<S> withInitial(@NonNull Supplier<? extends S> supplier) {
        if (supplier == null) {
            throw new NullPointerException("supplier is null");
        }
        return new SuppliedTransmittableThreadLocal<S>(supplier, null, null);
    }

    @ParametersAreNonnullByDefault
    @NonNull
    public static <S> TransmittableThreadLocal<S> withInitialAndCopier(Supplier<? extends S> supplier, TtlCopier<S> copierForChildValueAndCopy) {
        if (supplier == null) {
            throw new NullPointerException("supplier is null");
        }
        if (copierForChildValueAndCopy == null) {
            throw new NullPointerException("ttl copier is null");
        }
        return new SuppliedTransmittableThreadLocal<S>(supplier, copierForChildValueAndCopy, copierForChildValueAndCopy);
    }

    @ParametersAreNonnullByDefault
    @NonNull
    public static <S> TransmittableThreadLocal<S> withInitialAndCopier(Supplier<? extends S> supplier, TtlCopier<S> copierForChildValue, TtlCopier<S> copierForCopy) {
        if (supplier == null) {
            throw new NullPointerException("supplier is null");
        }
        if (copierForChildValue == null) {
            throw new NullPointerException("ttl copier for child value is null");
        }
        if (copierForCopy == null) {
            throw new NullPointerException("ttl copier for copy value is null");
        }
        return new SuppliedTransmittableThreadLocal<S>(supplier, copierForChildValue, copierForCopy);
    }

    @Override
    public T copy(T parentValue) {
        return parentValue;
    }

    protected void beforeExecute() {
    }

    protected void afterExecute() {
    }

    @Override
    public final T get() {
        Object value = super.get();
        if (this.disableIgnoreNullValueSemantics || null != value) {
            this.addThisToHolder();
        }
        return value;
    }

    @Override
    public final void set(T value) {
        if (!this.disableIgnoreNullValueSemantics && null == value) {
            this.remove();
        } else {
            super.set(value);
            this.addThisToHolder();
        }
    }

    @Override
    public final void remove() {
        this.removeThisFromHolder();
        super.remove();
    }

    private void superRemove() {
        super.remove();
    }

    private T copyValue() {
        return this.copy(this.get());
    }

    private void addThisToHolder() {
        if (!((WeakHashMap)holder.get()).containsKey(this)) {
            ((WeakHashMap)holder.get()).put(this, null);
        }
    }

    private void removeThisFromHolder() {
        ((WeakHashMap)holder.get()).remove(this);
    }

    private static void doExecuteCallback(boolean isBefore) {
        WeakHashMap ttlInstances = new WeakHashMap((Map)holder.get());
        for (TransmittableThreadLocal threadLocal : ttlInstances.keySet()) {
            try {
                if (isBefore) {
                    threadLocal.beforeExecute();
                    continue;
                }
                threadLocal.afterExecute();
            }
            catch (Throwable t) {
                if (!logger.isLoggable(Level.WARNING)) continue;
                logger.log(Level.WARNING, "TTL exception when " + (isBefore ? "beforeExecute" : "afterExecute") + ", cause: " + t, t);
            }
        }
    }

    static void dump(@Nullable String title) {
        if (title != null && title.length() > 0) {
            System.out.printf("Start TransmittableThreadLocal[%s] Dump...%n", title);
        } else {
            System.out.println("Start TransmittableThreadLocal Dump...");
        }
        for (TransmittableThreadLocal threadLocal : ((WeakHashMap)holder.get()).keySet()) {
            System.out.println(threadLocal.get());
        }
        System.out.println("TransmittableThreadLocal Dump end!");
    }

    static void dump() {
        TransmittableThreadLocal.dump(null);
    }

    public static class Transmitter {
        private static volatile WeakHashMap<ThreadLocal<Object>, TtlCopier<Object>> threadLocalHolder = new WeakHashMap();
        private static final Object threadLocalHolderUpdateLock = new Object();
        private static final Object threadLocalClearMark = new Object();
        private static final TtlCopier<Object> shadowCopier = parentValue -> parentValue;

        @NonNull
        public static Object capture() {
            return new Snapshot(Transmitter.captureTtlValues(), Transmitter.captureThreadLocalValues());
        }

        private static HashMap<TransmittableThreadLocal<Object>, Object> captureTtlValues() {
            HashMap<TransmittableThreadLocal<Object>, Object> ttl2Value = new HashMap<TransmittableThreadLocal<Object>, Object>();
            for (TransmittableThreadLocal threadLocal : ((WeakHashMap)holder.get()).keySet()) {
                ttl2Value.put(threadLocal, threadLocal.copyValue());
            }
            return ttl2Value;
        }

        private static HashMap<ThreadLocal<Object>, Object> captureThreadLocalValues() {
            HashMap<ThreadLocal<Object>, Object> threadLocal2Value = new HashMap<ThreadLocal<Object>, Object>();
            for (Map.Entry<ThreadLocal<Object>, TtlCopier<Object>> entry : threadLocalHolder.entrySet()) {
                ThreadLocal<Object> threadLocal = entry.getKey();
                TtlCopier<Object> copier = entry.getValue();
                threadLocal2Value.put(threadLocal, copier.copy(threadLocal.get()));
            }
            return threadLocal2Value;
        }

        @NonNull
        public static Object replay(@NonNull Object captured) {
            Snapshot capturedSnapshot = (Snapshot)captured;
            return new Snapshot(Transmitter.replayTtlValues(capturedSnapshot.ttl2Value), Transmitter.replayThreadLocalValues(capturedSnapshot.threadLocal2Value));
        }

        @NonNull
        private static HashMap<TransmittableThreadLocal<Object>, Object> replayTtlValues(@NonNull HashMap<TransmittableThreadLocal<Object>, Object> captured) {
            HashMap<TransmittableThreadLocal<Object>, Object> backup = new HashMap<TransmittableThreadLocal<Object>, Object>();
            Iterator iterator = ((WeakHashMap)holder.get()).keySet().iterator();
            while (iterator.hasNext()) {
                TransmittableThreadLocal threadLocal = (TransmittableThreadLocal)iterator.next();
                backup.put(threadLocal, threadLocal.get());
                if (captured.containsKey(threadLocal)) continue;
                iterator.remove();
                threadLocal.superRemove();
            }
            Transmitter.setTtlValuesTo(captured);
            TransmittableThreadLocal.doExecuteCallback(true);
            return backup;
        }

        private static HashMap<ThreadLocal<Object>, Object> replayThreadLocalValues(@NonNull HashMap<ThreadLocal<Object>, Object> captured) {
            HashMap<ThreadLocal<Object>, Object> backup = new HashMap<ThreadLocal<Object>, Object>();
            for (Map.Entry<ThreadLocal<Object>, Object> entry : captured.entrySet()) {
                ThreadLocal<Object> threadLocal = entry.getKey();
                backup.put(threadLocal, threadLocal.get());
                Object value = entry.getValue();
                if (value == threadLocalClearMark) {
                    threadLocal.remove();
                    continue;
                }
                threadLocal.set(value);
            }
            return backup;
        }

        @NonNull
        public static Object clear() {
            HashMap ttl2Value = new HashMap();
            HashMap<ThreadLocal<Object>, Object> threadLocal2Value = new HashMap<ThreadLocal<Object>, Object>();
            for (Map.Entry<ThreadLocal<Object>, TtlCopier<Object>> entry : threadLocalHolder.entrySet()) {
                ThreadLocal<Object> threadLocal = entry.getKey();
                threadLocal2Value.put(threadLocal, threadLocalClearMark);
            }
            return Transmitter.replay(new Snapshot(ttl2Value, threadLocal2Value));
        }

        public static void restore(@NonNull Object backup) {
            Snapshot backupSnapshot = (Snapshot)backup;
            Transmitter.restoreTtlValues(backupSnapshot.ttl2Value);
            Transmitter.restoreThreadLocalValues(backupSnapshot.threadLocal2Value);
        }

        private static void restoreTtlValues(@NonNull HashMap<TransmittableThreadLocal<Object>, Object> backup) {
            TransmittableThreadLocal.doExecuteCallback(false);
            Iterator iterator = ((WeakHashMap)holder.get()).keySet().iterator();
            while (iterator.hasNext()) {
                TransmittableThreadLocal threadLocal = (TransmittableThreadLocal)iterator.next();
                if (backup.containsKey(threadLocal)) continue;
                iterator.remove();
                threadLocal.superRemove();
            }
            Transmitter.setTtlValuesTo(backup);
        }

        private static void setTtlValuesTo(@NonNull HashMap<TransmittableThreadLocal<Object>, Object> ttlValues) {
            for (Map.Entry<TransmittableThreadLocal<Object>, Object> entry : ttlValues.entrySet()) {
                TransmittableThreadLocal<Object> threadLocal = entry.getKey();
                threadLocal.set(entry.getValue());
            }
        }

        private static void restoreThreadLocalValues(@NonNull HashMap<ThreadLocal<Object>, Object> backup) {
            for (Map.Entry<ThreadLocal<Object>, Object> entry : backup.entrySet()) {
                ThreadLocal<Object> threadLocal = entry.getKey();
                threadLocal.set(entry.getValue());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static <R> R runSupplierWithCaptured(@NonNull Object captured, @NonNull Supplier<R> bizLogic) {
            Object backup = Transmitter.replay(captured);
            try {
                R r = bizLogic.get();
                return r;
            }
            finally {
                Transmitter.restore(backup);
            }
        }

        public static <R> R runSupplierWithClear(@NonNull Supplier<R> bizLogic) {
            Object backup = Transmitter.clear();
            try {
                R r = bizLogic.get();
                return r;
            }
            finally {
                Transmitter.restore(backup);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @SuppressFBWarnings(value={"THROWS_METHOD_THROWS_CLAUSE_BASIC_EXCEPTION"})
        public static <R> R runCallableWithCaptured(@NonNull Object captured, @NonNull Callable<R> bizLogic) throws Exception {
            Object backup = Transmitter.replay(captured);
            try {
                R r = bizLogic.call();
                return r;
            }
            finally {
                Transmitter.restore(backup);
            }
        }

        @SuppressFBWarnings(value={"THROWS_METHOD_THROWS_CLAUSE_BASIC_EXCEPTION"})
        public static <R> R runCallableWithClear(@NonNull Callable<R> bizLogic) throws Exception {
            Object backup = Transmitter.clear();
            try {
                R r = bizLogic.call();
                return r;
            }
            finally {
                Transmitter.restore(backup);
            }
        }

        public static <T> boolean registerThreadLocal(@NonNull ThreadLocal<T> threadLocal, @NonNull TtlCopier<T> copier) {
            return Transmitter.registerThreadLocal(threadLocal, copier, false);
        }

        public static <T> boolean registerThreadLocalWithShadowCopier(@NonNull ThreadLocal<T> threadLocal) {
            return Transmitter.registerThreadLocal(threadLocal, shadowCopier, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static <T> boolean registerThreadLocal(@NonNull ThreadLocal<T> threadLocal, @NonNull TtlCopier<T> copier, boolean force) {
            if (threadLocal instanceof TransmittableThreadLocal) {
                logger.warning("register a TransmittableThreadLocal instance, this is unnecessary!");
                return true;
            }
            Object object = threadLocalHolderUpdateLock;
            synchronized (object) {
                if (!force && threadLocalHolder.containsKey(threadLocal)) {
                    return false;
                }
                WeakHashMap<ThreadLocal<Object>, TtlCopier<Object>> newHolder = new WeakHashMap<ThreadLocal<Object>, TtlCopier<Object>>(threadLocalHolder);
                newHolder.put(threadLocal, copier);
                threadLocalHolder = newHolder;
                return true;
            }
        }

        public static <T> boolean registerThreadLocalWithShadowCopier(@NonNull ThreadLocal<T> threadLocal, boolean force) {
            return Transmitter.registerThreadLocal(threadLocal, shadowCopier, force);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static <T> boolean unregisterThreadLocal(@NonNull ThreadLocal<T> threadLocal) {
            if (threadLocal instanceof TransmittableThreadLocal) {
                logger.warning("unregister a TransmittableThreadLocal instance, this is unnecessary!");
                return true;
            }
            Object object = threadLocalHolderUpdateLock;
            synchronized (object) {
                if (!threadLocalHolder.containsKey(threadLocal)) {
                    return false;
                }
                WeakHashMap<ThreadLocal<Object>, TtlCopier<Object>> newHolder = new WeakHashMap<ThreadLocal<Object>, TtlCopier<Object>>(threadLocalHolder);
                newHolder.remove(threadLocal);
                threadLocalHolder = newHolder;
                return true;
            }
        }

        private Transmitter() {
            throw new InstantiationError("Must not instantiate this class");
        }

        private static class Snapshot {
            final HashMap<TransmittableThreadLocal<Object>, Object> ttl2Value;
            final HashMap<ThreadLocal<Object>, Object> threadLocal2Value;

            private Snapshot(HashMap<TransmittableThreadLocal<Object>, Object> ttl2Value, HashMap<ThreadLocal<Object>, Object> threadLocal2Value) {
                this.ttl2Value = ttl2Value;
                this.threadLocal2Value = threadLocal2Value;
            }
        }
    }

    private static final class SuppliedTransmittableThreadLocal<T>
    extends TransmittableThreadLocal<T> {
        private final Supplier<? extends T> supplier;
        private final TtlCopier<T> copierForChildValue;
        private final TtlCopier<T> copierForCopy;

        SuppliedTransmittableThreadLocal(Supplier<? extends T> supplier, TtlCopier<T> copierForChildValue, TtlCopier<T> copierForCopy) {
            if (supplier == null) {
                throw new NullPointerException("supplier is null");
            }
            this.supplier = supplier;
            this.copierForChildValue = copierForChildValue;
            this.copierForCopy = copierForCopy;
        }

        @Override
        protected T initialValue() {
            return this.supplier.get();
        }

        @Override
        protected T childValue(T parentValue) {
            if (this.copierForChildValue != null) {
                return this.copierForChildValue.copy(parentValue);
            }
            return super.childValue(parentValue);
        }

        @Override
        public T copy(T parentValue) {
            if (this.copierForCopy != null) {
                return this.copierForCopy.copy(parentValue);
            }
            return super.copy(parentValue);
        }
    }
}

