/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.autoconfigure;

import com.alicp.jetcache.AbstractCacheBuilder;
import com.alicp.jetcache.CacheBuilder;
import com.alicp.jetcache.anno.support.ConfigProvider;
import com.alicp.jetcache.autoconfigure.AutoConfigureBeans;
import com.alicp.jetcache.autoconfigure.ConfigTree;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.util.Assert;

public abstract class AbstractCacheAutoInit {
    private static Logger logger = LoggerFactory.getLogger(AbstractCacheAutoInit.class);
    @Autowired
    protected ConfigurableEnvironment environment;
    @Autowired
    protected AutoConfigureBeans autoConfigureBeans;
    @Autowired
    protected ConfigProvider configProvider;
    protected String[] typeNames;
    private boolean inited = false;

    public AbstractCacheAutoInit(String ... cacheTypes) {
        Objects.requireNonNull(cacheTypes, "cacheTypes can't be null");
        Assert.isTrue((cacheTypes.length > 0 ? 1 : 0) != 0, (String)"cacheTypes length is 0");
        this.typeNames = cacheTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    public void init() {
        if (!this.inited) {
            AbstractCacheAutoInit abstractCacheAutoInit = this;
            synchronized (abstractCacheAutoInit) {
                if (!this.inited) {
                    this.process("jetcache.local.", this.autoConfigureBeans.getLocalCacheBuilders(), true);
                    this.process("jetcache.remote.", this.autoConfigureBeans.getRemoteCacheBuilders(), false);
                    this.inited = true;
                }
            }
        }
    }

    private void process(String prefix, Map cacheBuilders, boolean local) {
        ConfigTree resolver = new ConfigTree(this.environment, prefix);
        Map<String, Object> m = resolver.getProperties();
        Set cacheAreaNames = m.keySet().stream().map(s -> s.substring(0, s.indexOf(46))).collect(Collectors.toSet());
        for (String cacheArea : cacheAreaNames) {
            Object configType = m.get(cacheArea + ".type");
            boolean match = Arrays.stream(this.typeNames).anyMatch(tn -> tn.equals(configType));
            if (!match) continue;
            ConfigTree ct = resolver.subTree(cacheArea + ".");
            logger.info("init cache area {} , type= {}", (Object)cacheArea, (Object)this.typeNames[0]);
            CacheBuilder c = this.initCache(ct, local ? "local." + cacheArea : "remote." + cacheArea);
            cacheBuilders.put(cacheArea, c);
        }
    }

    protected void parseGeneralConfig(CacheBuilder builder, ConfigTree ct) {
        String expireAfterAccessInMillis;
        AbstractCacheBuilder acb = (AbstractCacheBuilder)builder;
        acb.keyConvertor(this.configProvider.parseKeyConvertor((String)ct.getProperty("keyConvertor")));
        String expireAfterWriteInMillis = (String)ct.getProperty("expireAfterWriteInMillis");
        if (expireAfterWriteInMillis == null) {
            expireAfterWriteInMillis = (String)ct.getProperty("defaultExpireInMillis");
        }
        if (expireAfterWriteInMillis != null) {
            acb.setExpireAfterWriteInMillis(Long.parseLong(expireAfterWriteInMillis));
        }
        if ((expireAfterAccessInMillis = (String)ct.getProperty("expireAfterAccessInMillis")) != null) {
            acb.setExpireAfterAccessInMillis(Long.parseLong(expireAfterAccessInMillis));
        }
    }

    protected abstract CacheBuilder initCache(ConfigTree var1, String var2);
}

