/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.embedded;

import com.alicp.jetcache.CacheValueHolder;
import com.alicp.jetcache.embedded.AbstractEmbeddedCache;
import com.alicp.jetcache.embedded.EmbeddedCacheConfig;
import com.alicp.jetcache.embedded.InnerMap;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Expiry;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class CaffeineCache<K, V>
extends AbstractEmbeddedCache<K, V> {
    private Cache cache;

    public CaffeineCache(EmbeddedCacheConfig<K, V> config) {
        super(config);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) {
        if (clazz.equals(Cache.class)) {
            return (T)this.cache;
        }
        throw new IllegalArgumentException(clazz.getName());
    }

    @Override
    protected InnerMap createAreaCache() {
        Caffeine builder = Caffeine.newBuilder();
        builder.maximumSize((long)this.config.getLimit());
        final boolean isExpireAfterAccess = this.config.isExpireAfterAccess();
        final long expireAfterAccess = this.config.getExpireAfterAccessInMillis();
        builder.expireAfter((Expiry)new Expiry<Object, CacheValueHolder>(){

            private long getRestTimeInNanos(CacheValueHolder value) {
                long now = System.currentTimeMillis();
                long ttl = value.getExpireTime() - now;
                if (isExpireAfterAccess) {
                    ttl = Math.min(ttl, expireAfterAccess);
                }
                return TimeUnit.MILLISECONDS.toNanos(ttl);
            }

            public long expireAfterCreate(Object key, CacheValueHolder value, long currentTime) {
                return this.getRestTimeInNanos(value);
            }

            public long expireAfterUpdate(Object key, CacheValueHolder value, long currentTime, long currentDuration) {
                return currentDuration;
            }

            public long expireAfterRead(Object key, CacheValueHolder value, long currentTime, long currentDuration) {
                return this.getRestTimeInNanos(value);
            }
        });
        this.cache = builder.build();
        return new InnerMap(){

            @Override
            public Object getValue(Object key) {
                return CaffeineCache.this.cache.getIfPresent(key);
            }

            @Override
            public Map getAllValues(Collection keys) {
                return CaffeineCache.this.cache.getAllPresent((Iterable)keys);
            }

            @Override
            public void putValue(Object key, Object value) {
                CaffeineCache.this.cache.put(key, value);
            }

            @Override
            public void putAllValues(Map map) {
                CaffeineCache.this.cache.putAll(map);
            }

            @Override
            public boolean removeValue(Object key) {
                return CaffeineCache.this.cache.asMap().remove(key) != null;
            }

            @Override
            public void removeAllValues(Collection keys) {
                CaffeineCache.this.cache.invalidateAll((Iterable)keys);
            }

            @Override
            public boolean putIfAbsentValue(Object key, Object value) {
                return CaffeineCache.this.cache.asMap().putIfAbsent(key, value) == null;
            }
        };
    }
}

