/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.support;

import com.alicp.jetcache.CacheException;
import java.io.Serializable;

public class CacheStat
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -8802969946750554026L;
    protected String cacheName;
    protected long statStartTime;
    protected long statEndTime;
    protected long getCount;
    protected long getHitCount;
    protected long getMissCount;
    protected long getFailCount;
    protected long getExpireCount;
    protected long getTimeSum;
    protected long minGetTime = Long.MAX_VALUE;
    protected long maxGetTime = 0L;
    protected long putCount;
    protected long putSuccessCount;
    protected long putFailCount;
    protected long putTimeSum;
    protected long minPutTime = Long.MAX_VALUE;
    protected long maxPutTime = 0L;
    protected long removeCount;
    protected long removeSuccessCount;
    protected long removeFailCount;
    protected long removeTimeSum;
    protected long minRemoveTime = Long.MAX_VALUE;
    protected long maxRemoveTime = 0L;
    protected long loadCount;
    protected long loadSuccessCount;
    protected long loadFailCount;
    protected long loadTimeSum;
    protected long minLoadTime = Long.MAX_VALUE;
    protected long maxLoadTime = 0L;

    public CacheStat clone() {
        try {
            return (CacheStat)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new CacheException(e);
        }
    }

    private double tps(long count) {
        long t = this.statEndTime;
        if (t == 0L) {
            t = System.currentTimeMillis();
        }
        if ((t -= this.statStartTime) == 0L) {
            return 0.0;
        }
        return 1000.0 * (double)count / (double)t;
    }

    public double qps() {
        return this.tps(this.getCount);
    }

    public double putTps() {
        return this.tps(this.putCount);
    }

    public double removeTps() {
        return this.tps(this.removeCount);
    }

    public double loadQps() {
        return this.tps(this.loadCount);
    }

    public double hitRate() {
        if (this.getCount == 0L) {
            return 0.0;
        }
        return 1.0 * (double)this.getHitCount / (double)this.getCount;
    }

    public double avgGetTime() {
        if (this.getCount == 0L) {
            return 0.0;
        }
        return 1.0 * (double)this.getTimeSum / (double)this.getCount;
    }

    public double avgPutTime() {
        if (this.putCount == 0L) {
            return 0.0;
        }
        return 1.0 * (double)this.putTimeSum / (double)this.putCount;
    }

    public double avgRemoveTime() {
        if (this.removeCount == 0L) {
            return 0.0;
        }
        return 1.0 * (double)this.removeTimeSum / (double)this.removeCount;
    }

    public double avgLoadTime() {
        if (this.loadCount == 0L) {
            return 0.0;
        }
        return 1.0 * (double)this.loadTimeSum / (double)this.loadCount;
    }

    public long getGetCount() {
        return this.getCount;
    }

    public void setGetCount(long getCount) {
        this.getCount = getCount;
    }

    public long getGetHitCount() {
        return this.getHitCount;
    }

    public void setGetHitCount(long getHitCount) {
        this.getHitCount = getHitCount;
    }

    public long getGetMissCount() {
        return this.getMissCount;
    }

    public void setGetMissCount(long getMissCount) {
        this.getMissCount = getMissCount;
    }

    public long getGetFailCount() {
        return this.getFailCount;
    }

    public void setGetFailCount(long getFailCount) {
        this.getFailCount = getFailCount;
    }

    public long getGetExpireCount() {
        return this.getExpireCount;
    }

    public void setGetExpireCount(long getExpireCount) {
        this.getExpireCount = getExpireCount;
    }

    public long getGetTimeSum() {
        return this.getTimeSum;
    }

    public void setGetTimeSum(long getTimeSum) {
        this.getTimeSum = getTimeSum;
    }

    public long getMinGetTime() {
        return this.minGetTime;
    }

    public void setMinGetTime(long minGetTime) {
        this.minGetTime = minGetTime;
    }

    public long getMaxGetTime() {
        return this.maxGetTime;
    }

    public void setMaxGetTime(long maxGetTime) {
        this.maxGetTime = maxGetTime;
    }

    public long getPutCount() {
        return this.putCount;
    }

    public void setPutCount(long putCount) {
        this.putCount = putCount;
    }

    public long getPutSuccessCount() {
        return this.putSuccessCount;
    }

    public void setPutSuccessCount(long putSuccessCount) {
        this.putSuccessCount = putSuccessCount;
    }

    public long getPutFailCount() {
        return this.putFailCount;
    }

    public void setPutFailCount(long putFailCount) {
        this.putFailCount = putFailCount;
    }

    public long getPutTimeSum() {
        return this.putTimeSum;
    }

    public void setPutTimeSum(long putTimeSum) {
        this.putTimeSum = putTimeSum;
    }

    public long getMinPutTime() {
        return this.minPutTime;
    }

    public void setMinPutTime(long minPutTime) {
        this.minPutTime = minPutTime;
    }

    public long getMaxPutTime() {
        return this.maxPutTime;
    }

    public void setMaxPutTime(long maxPutTime) {
        this.maxPutTime = maxPutTime;
    }

    public long getRemoveCount() {
        return this.removeCount;
    }

    public void setRemoveCount(long removeCount) {
        this.removeCount = removeCount;
    }

    public long getRemoveSuccessCount() {
        return this.removeSuccessCount;
    }

    public void setRemoveSuccessCount(long removeSuccessCount) {
        this.removeSuccessCount = removeSuccessCount;
    }

    public long getRemoveFailCount() {
        return this.removeFailCount;
    }

    public void setRemoveFailCount(long removeFailCount) {
        this.removeFailCount = removeFailCount;
    }

    public long getRemoveTimeSum() {
        return this.removeTimeSum;
    }

    public void setRemoveTimeSum(long removeTimeSum) {
        this.removeTimeSum = removeTimeSum;
    }

    public long getMinRemoveTime() {
        return this.minRemoveTime;
    }

    public void setMinRemoveTime(long minRemoveTime) {
        this.minRemoveTime = minRemoveTime;
    }

    public long getMaxRemoveTime() {
        return this.maxRemoveTime;
    }

    public void setMaxRemoveTime(long maxRemoveTime) {
        this.maxRemoveTime = maxRemoveTime;
    }

    public long getLoadCount() {
        return this.loadCount;
    }

    public void setLoadCount(long loadCount) {
        this.loadCount = loadCount;
    }

    public long getLoadSuccessCount() {
        return this.loadSuccessCount;
    }

    public void setLoadSuccessCount(long loadSuccessCount) {
        this.loadSuccessCount = loadSuccessCount;
    }

    public long getLoadFailCount() {
        return this.loadFailCount;
    }

    public void setLoadFailCount(long loadFailCount) {
        this.loadFailCount = loadFailCount;
    }

    public long getLoadTimeSum() {
        return this.loadTimeSum;
    }

    public void setLoadTimeSum(long loadTimeSum) {
        this.loadTimeSum = loadTimeSum;
    }

    public long getMinLoadTime() {
        return this.minLoadTime;
    }

    public void setMinLoadTime(long minLoadTime) {
        this.minLoadTime = minLoadTime;
    }

    public long getMaxLoadTime() {
        return this.maxLoadTime;
    }

    public void setMaxLoadTime(long maxLoadTime) {
        this.maxLoadTime = maxLoadTime;
    }

    public long getStatStartTime() {
        return this.statStartTime;
    }

    public void setStatStartTime(long statStartTime) {
        this.statStartTime = statStartTime;
    }

    public long getStatEndTime() {
        return this.statEndTime;
    }

    public void setStatEndTime(long statEndTime) {
        this.statEndTime = statEndTime;
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public void setCacheName(String cacheName) {
        this.cacheName = cacheName;
    }
}

