/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.remoting;

import com.alipay.remoting.Connection;
import com.alipay.remoting.ConnectionMonitorStrategy;
import com.alipay.remoting.ConnectionPool;
import com.alipay.remoting.SystemProperties;
import com.alipay.remoting.log.BoltLoggerFactory;
import com.alipay.remoting.util.FutureTaskUtil;
import com.alipay.remoting.util.RemotingUtil;
import com.alipay.remoting.util.RunStateRecordedFutureTask;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;

public class ScheduledDisconnectStrategy
implements ConnectionMonitorStrategy {
    private static final Logger logger = BoltLoggerFactory.getLogger("CommonDefault");
    private static final int CONNECTION_THRESHOLD = SystemProperties.conn_threshold();
    private Map<String, Connection> freshSelectConnections = new ConcurrentHashMap<String, Connection>();
    private static int RETRY_DETECT_PERIOD = SystemProperties.retry_detect_period();
    private Random random = new Random();

    @Override
    public Map<String, List<Connection>> filter(List<Connection> connections) {
        ArrayList<Connection> serviceOnConnections = new ArrayList<Connection>();
        ArrayList<Connection> serviceOffConnections = new ArrayList<Connection>();
        ConcurrentHashMap<String, List<Connection>> filteredConnections = new ConcurrentHashMap<String, List<Connection>>();
        for (Connection connection : connections) {
            String serviceStatus = (String)connection.getAttribute("bolt.conn.service.status");
            if (serviceStatus != null) {
                if (!connection.isInvokeFutureMapFinish() || this.freshSelectConnections.containsValue(connection)) continue;
                serviceOffConnections.add(connection);
                continue;
            }
            serviceOnConnections.add(connection);
        }
        filteredConnections.put("on", serviceOnConnections);
        filteredConnections.put("off", serviceOffConnections);
        return filteredConnections;
    }

    @Override
    public void monitor(Map<String, RunStateRecordedFutureTask<ConnectionPool>> connPools) {
        try {
            if (null != connPools && !connPools.isEmpty()) {
                for (Map.Entry<String, RunStateRecordedFutureTask<ConnectionPool>> entry : connPools.entrySet()) {
                    String poolKey = entry.getKey();
                    ConnectionPool pool = FutureTaskUtil.getFutureTaskResult(entry.getValue(), logger);
                    List<Connection> connections = pool.getAll();
                    Map<String, List<Connection>> filteredConnectons = this.filter(connections);
                    List<Connection> serviceOnConnections = filteredConnectons.get("on");
                    List<Connection> serviceOffConnections = filteredConnectons.get("off");
                    if (serviceOnConnections.size() > CONNECTION_THRESHOLD) {
                        Connection freshSelectConnect = serviceOnConnections.get(this.random.nextInt(serviceOnConnections.size()));
                        freshSelectConnect.setAttribute("bolt.conn.service.status", "off");
                        Connection lastSelectConnect = this.freshSelectConnections.remove(poolKey);
                        this.freshSelectConnections.put(poolKey, freshSelectConnect);
                        this.closeFreshSelectConnections(lastSelectConnect, serviceOffConnections);
                    } else {
                        if (this.freshSelectConnections.containsKey(poolKey)) {
                            Connection lastSelectConnect = this.freshSelectConnections.remove(poolKey);
                            this.closeFreshSelectConnections(lastSelectConnect, serviceOffConnections);
                        }
                        if (logger.isInfoEnabled()) {
                            logger.info("the size of serviceOnConnections [{}] reached CONNECTION_THRESHOLD [{}].", (Object)serviceOnConnections.size(), (Object)CONNECTION_THRESHOLD);
                        }
                    }
                    for (Connection offConn : serviceOffConnections) {
                        if (!offConn.isFine()) continue;
                        offConn.close();
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("ScheduledDisconnectStrategy monitor error", (Throwable)e);
        }
    }

    private void closeFreshSelectConnections(Connection lastSelectConnect, List<Connection> serviceOffConnections) throws InterruptedException {
        if (null != lastSelectConnect) {
            if (lastSelectConnect.isInvokeFutureMapFinish()) {
                serviceOffConnections.add(lastSelectConnect);
            } else {
                Thread.sleep(RETRY_DETECT_PERIOD);
                if (lastSelectConnect.isInvokeFutureMapFinish()) {
                    serviceOffConnections.add(lastSelectConnect);
                } else if (logger.isInfoEnabled()) {
                    logger.info("Address={} won't close at this schedule turn", (Object)RemotingUtil.parseRemoteAddress(lastSelectConnect.getChannel()));
                }
            }
        }
    }
}

