/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.remoting.connection;

import com.alipay.remoting.Connection;
import com.alipay.remoting.ConnectionEventHandler;
import com.alipay.remoting.ConnectionEventType;
import com.alipay.remoting.NamedThreadFactory;
import com.alipay.remoting.ProtocolCode;
import com.alipay.remoting.Url;
import com.alipay.remoting.codec.Codec;
import com.alipay.remoting.config.ConfigManager;
import com.alipay.remoting.config.ConfigurableInstance;
import com.alipay.remoting.connection.ConnectionFactory;
import com.alipay.remoting.log.BoltLoggerFactory;
import com.alipay.remoting.util.NettyEventLoopUtil;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.timeout.IdleStateHandler;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public abstract class AbstractConnectionFactory
implements ConnectionFactory {
    private static final Logger logger = BoltLoggerFactory.getLogger(AbstractConnectionFactory.class);
    private static final EventLoopGroup workerGroup = NettyEventLoopUtil.newEventLoopGroup(Runtime.getRuntime().availableProcessors() + 1, new NamedThreadFactory("bolt-netty-client-worker", true));
    private final ConfigurableInstance confInstance;
    private final Codec codec;
    private final ChannelHandler heartbeatHandler;
    private final ChannelHandler handler;
    protected Bootstrap bootstrap;

    public AbstractConnectionFactory(Codec codec, ChannelHandler heartbeatHandler, ChannelHandler handler, ConfigurableInstance confInstance) {
        if (codec == null) {
            throw new IllegalArgumentException("null codec");
        }
        if (handler == null) {
            throw new IllegalArgumentException("null handler");
        }
        this.confInstance = confInstance;
        this.codec = codec;
        this.heartbeatHandler = heartbeatHandler;
        this.handler = handler;
    }

    @Override
    public void init(final ConnectionEventHandler connectionEventHandler) {
        this.bootstrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)this.bootstrap.group(workerGroup)).channel(NettyEventLoopUtil.getClientSocketChannelClass())).option(ChannelOption.TCP_NODELAY, (Object)ConfigManager.tcp_nodelay())).option(ChannelOption.SO_REUSEADDR, (Object)ConfigManager.tcp_so_reuseaddr())).option(ChannelOption.SO_KEEPALIVE, (Object)ConfigManager.tcp_so_keepalive());
        this.initWriteBufferWaterMark();
        if (ConfigManager.netty_buffer_pooled()) {
            this.bootstrap.option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT);
        } else {
            this.bootstrap.option(ChannelOption.ALLOCATOR, (Object)UnpooledByteBufAllocator.DEFAULT);
        }
        this.bootstrap.handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel channel) {
                ChannelPipeline pipeline = channel.pipeline();
                pipeline.addLast("decoder", AbstractConnectionFactory.this.codec.newDecoder());
                pipeline.addLast("encoder", AbstractConnectionFactory.this.codec.newEncoder());
                boolean idleSwitch = ConfigManager.tcp_idle_switch();
                if (idleSwitch) {
                    pipeline.addLast("idleStateHandler", (ChannelHandler)new IdleStateHandler((long)ConfigManager.tcp_idle(), (long)ConfigManager.tcp_idle(), 0L, TimeUnit.MILLISECONDS));
                    pipeline.addLast("heartbeatHandler", AbstractConnectionFactory.this.heartbeatHandler);
                }
                pipeline.addLast("connectionEventHandler", (ChannelHandler)connectionEventHandler);
                pipeline.addLast("handler", AbstractConnectionFactory.this.handler);
            }
        });
    }

    @Override
    public Connection createConnection(Url url) throws Exception {
        Channel channel = this.doCreateConnection(url.getIp(), url.getPort(), url.getConnectTimeout());
        Connection conn = new Connection(channel, ProtocolCode.fromBytes(url.getProtocol()), url.getVersion(), url);
        channel.pipeline().fireUserEventTriggered((Object)ConnectionEventType.CONNECT);
        return conn;
    }

    @Override
    public Connection createConnection(String targetIP, int targetPort, int connectTimeout) throws Exception {
        Channel channel = this.doCreateConnection(targetIP, targetPort, connectTimeout);
        Connection conn = new Connection(channel, ProtocolCode.fromBytes(1), 1, new Url(targetIP, targetPort));
        channel.pipeline().fireUserEventTriggered((Object)ConnectionEventType.CONNECT);
        return conn;
    }

    @Override
    public Connection createConnection(String targetIP, int targetPort, byte version, int connectTimeout) throws Exception {
        Channel channel = this.doCreateConnection(targetIP, targetPort, connectTimeout);
        Connection conn = new Connection(channel, ProtocolCode.fromBytes(2), version, new Url(targetIP, targetPort));
        channel.pipeline().fireUserEventTriggered((Object)ConnectionEventType.CONNECT);
        return conn;
    }

    private void initWriteBufferWaterMark() {
        int highWaterMark;
        int lowWaterMark = this.confInstance.netty_buffer_low_watermark();
        if (lowWaterMark > (highWaterMark = this.confInstance.netty_buffer_high_watermark())) {
            throw new IllegalArgumentException(String.format("[client side] bolt netty high water mark {%s} should not be smaller than low water mark {%s} bytes)", highWaterMark, lowWaterMark));
        }
        logger.warn("[client side] bolt netty low water mark is {} bytes, high water mark is {} bytes", (Object)lowWaterMark, (Object)highWaterMark);
        this.bootstrap.option(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)new WriteBufferWaterMark(lowWaterMark, highWaterMark));
    }

    protected Channel doCreateConnection(String targetIP, int targetPort, int connectTimeout) throws Exception {
        connectTimeout = Math.max(connectTimeout, 1000);
        String address = targetIP + ":" + targetPort;
        if (logger.isDebugEnabled()) {
            logger.debug("connectTimeout of address [{}] is [{}].", (Object)address, (Object)connectTimeout);
        }
        this.bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)connectTimeout);
        ChannelFuture future = this.bootstrap.connect((SocketAddress)new InetSocketAddress(targetIP, targetPort));
        future.awaitUninterruptibly();
        if (!future.isDone()) {
            String errMsg = "Create connection to " + address + " timeout!";
            logger.warn(errMsg);
            throw new Exception(errMsg);
        }
        if (future.isCancelled()) {
            String errMsg = "Create connection to " + address + " cancelled by user!";
            logger.warn(errMsg);
            throw new Exception(errMsg);
        }
        if (!future.isSuccess()) {
            String errMsg = "Create connection to " + address + " error!";
            logger.warn(errMsg);
            throw new Exception(errMsg, future.cause());
        }
        return future.channel();
    }
}

