/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.common.log.factory;

import com.alipay.sofa.common.log.LogSpace;
import com.alipay.sofa.common.log.adapter.level.AdapterLevel;
import com.alipay.sofa.common.log.factory.AbstractLoggerSpaceFactory;
import com.alipay.sofa.common.log.factory.AbstractLoggerSpaceFactoryBuilder;
import com.alipay.sofa.common.space.SpaceId;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.log4j.Hierarchy;
import org.apache.log4j.Level;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.RootLogger;
import org.apache.log4j.xml.DOMConfigurator;
import org.slf4j.Logger;
import org.slf4j.impl.JCLLoggerAdapter;

public class LoggerSpaceFactory4CommonsLoggingBuilder
extends AbstractLoggerSpaceFactoryBuilder {
    public LoggerSpaceFactory4CommonsLoggingBuilder(SpaceId spaceId, LogSpace spaceInfo) {
        super(spaceId, spaceInfo);
    }

    @Override
    protected String getLoggingToolName() {
        return "log4j";
    }

    @Override
    public AbstractLoggerSpaceFactory doBuild(String spaceName, ClassLoader spaceClassloader, URL url) {
        try {
            Hierarchy repo = new Hierarchy((org.apache.log4j.Logger)new RootLogger(Level.WARN));
            DOMConfigurator domConfigurator = new DOMConfigurator();
            Field field = DOMConfigurator.class.getDeclaredField("props");
            field.setAccessible(true);
            field.set(domConfigurator, this.getProperties());
            domConfigurator.doConfigure(url, (LoggerRepository)repo);
            return new AbstractLoggerSpaceFactory(this.getLoggingToolName(), (LoggerRepository)repo){
                ConcurrentMap<String, JCLLoggerAdapter> loggerMap;
                final /* synthetic */ LoggerRepository val$repo;
                {
                    this.val$repo = loggerRepository;
                    super(source);
                    this.loggerMap = new ConcurrentHashMap<String, JCLLoggerAdapter>();
                }

                @Override
                public Logger setLevel(String loggerName, AdapterLevel adapterLevel) throws Exception {
                    JCLLoggerAdapter jclLoggerAdapter = (JCLLoggerAdapter)this.getLogger(loggerName);
                    org.apache.log4j.Logger log4j = this.val$repo.getLogger(loggerName);
                    Level log4jLevel = this.toLog4jLevel(adapterLevel);
                    log4j.setLevel(log4jLevel);
                    return jclLoggerAdapter;
                }

                public Logger getLogger(String name) {
                    JCLLoggerAdapter slf4jLogger = (JCLLoggerAdapter)this.loggerMap.get(name);
                    if (slf4jLogger != null) {
                        return slf4jLogger;
                    }
                    JCLLoggerAdapter newInst = this.createCommonsLoggingLoggerAdapter2Slf4j(name);
                    JCLLoggerAdapter oldInst = this.loggerMap.putIfAbsent(name, newInst);
                    return oldInst == null ? newInst : oldInst;
                }

                private JCLLoggerAdapter createCommonsLoggingLoggerAdapter2Slf4j(String name) {
                    org.apache.log4j.Logger log4j = this.val$repo.getLogger(name);
                    try {
                        Log4JLogger log4jLogger = new Log4JLogger(log4j);
                        Constructor constructor = JCLLoggerAdapter.class.getDeclaredConstructor(Log.class, String.class);
                        constructor.setAccessible(true);
                        return (JCLLoggerAdapter)constructor.newInstance(log4jLogger, name);
                    }
                    catch (Throwable e) {
                        throw new IllegalStateException("get adapter from commons-logging to slf4j logger from Log4j  err!", e);
                    }
                }

                private Level toLog4jLevel(AdapterLevel adapterLevel) {
                    if (adapterLevel == null) {
                        throw new IllegalStateException("AdapterLevel is NULL when adapter common-logging and log4j.");
                    }
                    switch (adapterLevel) {
                        case TRACE: {
                            return Level.TRACE;
                        }
                        case DEBUG: {
                            return Level.DEBUG;
                        }
                        case INFO: {
                            return Level.INFO;
                        }
                        case WARN: {
                            return Level.WARN;
                        }
                        case ERROR: {
                            return Level.ERROR;
                        }
                    }
                    throw new IllegalStateException((Object)((Object)adapterLevel) + " is unknown when adapter common-logging and log4j.");
                }
            };
        }
        catch (Throwable e) {
            throw new IllegalStateException("Log4j for commons-logging loggerSpaceFactory build error!", e);
        }
    }
}

