/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft;

import com.alipay.sofa.jraft.conf.Configuration;
import com.alipay.sofa.jraft.core.NodeImpl;
import com.alipay.sofa.jraft.entity.PeerId;
import com.alipay.sofa.jraft.option.BootstrapOptions;
import com.alipay.sofa.jraft.util.Endpoint;
import com.alipay.sofa.jraft.util.ThreadPoolUtil;
import java.util.concurrent.Executor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang.StringUtils;

public final class JRaftUtils {
    private JRaftUtils() {
    }

    public static boolean bootstrap(BootstrapOptions opts) throws InterruptedException {
        NodeImpl node = new NodeImpl();
        boolean ret = node.bootstrap(opts);
        node.shutdown();
        node.join();
        return ret;
    }

    public static Executor createExecutor(String prefix, int number) {
        if (number <= 0) {
            return null;
        }
        return ThreadPoolUtil.newThreadPool(prefix, true, number, number, 60L, new SynchronousQueue<Runnable>(), JRaftUtils.createThreadFactory(prefix));
    }

    public static ThreadFactory createThreadFactory(final String prefixName) {
        return new ThreadFactory(){
            private final AtomicInteger c = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setName(prefixName + this.c.getAndIncrement());
                t.setDaemon(true);
                return t;
            }
        };
    }

    public static Configuration getConfiguration(String s) {
        Configuration conf = new Configuration();
        if (StringUtils.isBlank((String)s)) {
            return conf;
        }
        if (conf.parse(s)) {
            return conf;
        }
        throw new IllegalArgumentException("Invalid conf str:" + s);
    }

    public static PeerId getPeerId(String s) {
        PeerId peer = new PeerId();
        if (StringUtils.isBlank((String)s)) {
            return peer;
        }
        if (peer.parse(s)) {
            return peer;
        }
        throw new IllegalArgumentException("Invalid peer str:" + s);
    }

    public static Endpoint getEndPoint(String s) {
        if (StringUtils.isBlank((String)s)) {
            return null;
        }
        String[] tmps = s.split(":");
        if (tmps.length != 2) {
            throw new IllegalArgumentException("Invalid endpoint string: " + s);
        }
        return new Endpoint(tmps[0], Integer.parseInt(tmps[1]));
    }
}

