/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.core;

import com.alipay.sofa.jraft.FSMCaller;
import com.alipay.sofa.jraft.ReadOnlyService;
import com.alipay.sofa.jraft.Status;
import com.alipay.sofa.jraft.closure.ReadIndexClosure;
import com.alipay.sofa.jraft.core.NodeImpl;
import com.alipay.sofa.jraft.entity.ReadIndexState;
import com.alipay.sofa.jraft.entity.ReadIndexStatus;
import com.alipay.sofa.jraft.error.RaftError;
import com.alipay.sofa.jraft.option.RaftOptions;
import com.alipay.sofa.jraft.option.ReadOnlyServiceOptions;
import com.alipay.sofa.jraft.rpc.RpcRequests;
import com.alipay.sofa.jraft.rpc.RpcResponseClosureAdapter;
import com.alipay.sofa.jraft.util.Bytes;
import com.alipay.sofa.jraft.util.LogExceptionHandler;
import com.alipay.sofa.jraft.util.NamedThreadFactory;
import com.alipay.sofa.jraft.util.OnlyForTest;
import com.alipay.sofa.jraft.util.Utils;
import com.google.protobuf.ZeroByteStringHelper;
import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.dsl.Disruptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class ReadOnlyServiceImpl
implements ReadOnlyService,
FSMCaller.LastAppliedLogIndexListener {
    private Disruptor<ReadIndexEvent> readIndexDisruptor;
    private RingBuffer<ReadIndexEvent> readIndexQueue;
    private RaftOptions raftOptions;
    private NodeImpl node;
    private final Lock lock = new ReentrantLock();
    private FSMCaller fsmCaller;
    private volatile CountDownLatch shutdownLatch;
    private ScheduledExecutorService scheduledExecutorService;
    private final TreeMap<Long, List<ReadIndexStatus>> pendingNotifyStatus = new TreeMap();

    private void executeReadIndexEvents(List<ReadIndexEvent> events) {
        if (events.isEmpty()) {
            return;
        }
        RpcRequests.ReadIndexRequest.Builder rb = RpcRequests.ReadIndexRequest.newBuilder();
        rb.setGroupId(this.node.getGroupId());
        rb.setServerId(this.node.getServerId().toString());
        ArrayList<ReadIndexState> states = new ArrayList<ReadIndexState>(events.size());
        for (ReadIndexEvent event : events) {
            rb.addEntries(ZeroByteStringHelper.wrap(event.requestContext.get()));
            states.add(new ReadIndexState(event.requestContext, event.done, event.startTime));
        }
        RpcRequests.ReadIndexRequest request = rb.build();
        this.node.handleReadIndexRequest(request, new ReadIndexResponseClosure(events, states, request));
    }

    @Override
    public boolean init(ReadOnlyServiceOptions opts) {
        this.node = opts.getNode();
        this.fsmCaller = opts.getFsmCaller();
        this.raftOptions = opts.getRaftOptions();
        this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(new NamedThreadFactory("ReadOnlyService-PendingNotify-Scanner", true));
        this.readIndexDisruptor = new Disruptor((EventFactory)new ReadIndexEventFactory(), this.raftOptions.getDisruptorBufferSize(), (ThreadFactory)new NamedThreadFactory("Jraft-ReadOnlyService-Disruptor-", true));
        this.readIndexDisruptor.handleEventsWith(new EventHandler[]{new ReadIndexEventHandler()});
        this.readIndexDisruptor.setDefaultExceptionHandler(new LogExceptionHandler(this.getClass().getSimpleName()));
        this.readIndexDisruptor.start();
        this.readIndexQueue = this.readIndexDisruptor.getRingBuffer();
        this.fsmCaller.addLastAppliedLogIndexListener(this);
        this.scheduledExecutorService.scheduleAtFixedRate(() -> this.onApplied(this.fsmCaller.getLastAppliedIndex()), this.raftOptions.getMaxElectionDelayMs(), this.raftOptions.getMaxElectionDelayMs(), TimeUnit.MILLISECONDS);
        return true;
    }

    @Override
    public synchronized void shutdown() {
        if (this.shutdownLatch != null) {
            return;
        }
        this.shutdownLatch = new CountDownLatch(1);
        this.readIndexQueue.publishEvent((event, sequence) -> {
            event.shutdownLatch = this.shutdownLatch;
        });
        this.scheduledExecutorService.shutdown();
    }

    @Override
    public void join() throws InterruptedException {
        if (this.shutdownLatch != null) {
            this.shutdownLatch.await();
        }
        this.readIndexDisruptor.shutdown();
        this.scheduledExecutorService.awaitTermination(5L, TimeUnit.SECONDS);
    }

    @Override
    public void addRequest(byte[] reqCtx, ReadIndexClosure closure) {
        if (this.shutdownLatch != null) {
            Utils.runClosureInThread(closure, new Status(RaftError.EHOSTDOWN, "was stopped", new Object[0]));
            throw new IllegalStateException("Service already shutdown.");
        }
        try {
            this.readIndexQueue.publishEvent((event, sequence) -> {
                event.done = closure;
                event.requestContext = new Bytes(reqCtx);
                event.startTime = Utils.monotonicMs();
            });
        }
        catch (Exception e) {
            Utils.runClosureInThread(closure, new Status(RaftError.EPERM, "Node is down.", new Object[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onApplied(long appliedIndex) {
        ArrayList pendingStatuses = null;
        this.lock.lock();
        try {
            if (this.pendingNotifyStatus.isEmpty()) {
                return;
            }
            NavigableMap<Long, List<ReadIndexStatus>> statuses = this.pendingNotifyStatus.headMap(appliedIndex, true);
            if (statuses != null) {
                pendingStatuses = new ArrayList(statuses.size() << 1);
                Iterator it = statuses.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    pendingStatuses.addAll((Collection)entry.getValue());
                    it.remove();
                }
            }
        }
        finally {
            this.lock.unlock();
            if (pendingStatuses != null && !pendingStatuses.isEmpty()) {
                for (ReadIndexStatus status : pendingStatuses) {
                    this.notifySuccess(status);
                }
            }
        }
    }

    @OnlyForTest
    void flush() throws InterruptedException {
        CountDownLatch latch = new CountDownLatch(1);
        this.readIndexQueue.publishEvent((task, sequence) -> {
            task.shutdownLatch = latch;
        });
        latch.await();
    }

    @OnlyForTest
    TreeMap<Long, List<ReadIndexStatus>> getPendingNotifyStatus() {
        return this.pendingNotifyStatus;
    }

    private void notifySuccess(ReadIndexStatus status) {
        long nowMs = Utils.monotonicMs();
        List<ReadIndexState> states = status.getStates();
        int taskCount = states.size();
        for (int i = 0; i < taskCount; ++i) {
            ReadIndexState task = states.get(i);
            ReadIndexClosure done = task.getDone();
            if (done == null) continue;
            this.node.getNodeMetrics().recordLatency("read-index", nowMs - task.getStartTimeMs());
            done.setResult(task.getIndex(), task.getRequestContext().get());
            done.run(Status.OK());
        }
    }

    class ReadIndexResponseClosure
    extends RpcResponseClosureAdapter<RpcRequests.ReadIndexResponse> {
        final List<ReadIndexEvent> events;
        final List<ReadIndexState> states;
        final RpcRequests.ReadIndexRequest request;

        public ReadIndexResponseClosure(List<ReadIndexEvent> events, List<ReadIndexState> states, RpcRequests.ReadIndexRequest request) {
            this.events = events;
            this.states = states;
            this.request = request;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run(Status status) {
            if (!status.isOk()) {
                this.notifyFail(status);
                return;
            }
            RpcRequests.ReadIndexResponse readIndexResponse = (RpcRequests.ReadIndexResponse)this.getResponse();
            if (!readIndexResponse.getSuccess()) {
                this.notifyFail(new Status(-1, "Fail to run ReadIndex task, maybe the leader stepped down."));
                return;
            }
            ReadIndexStatus readIndexStatus = new ReadIndexStatus(this.states, this.request, readIndexResponse.getIndex());
            for (ReadIndexState state : this.states) {
                state.setIndex(readIndexResponse.getIndex());
            }
            boolean doUnlock = true;
            ReadOnlyServiceImpl.this.lock.lock();
            try {
                if (readIndexStatus.isApplied(ReadOnlyServiceImpl.this.fsmCaller.getLastAppliedIndex())) {
                    ReadOnlyServiceImpl.this.lock.unlock();
                    doUnlock = false;
                    ReadOnlyServiceImpl.this.notifySuccess(readIndexStatus);
                } else {
                    ReadOnlyServiceImpl.this.pendingNotifyStatus.computeIfAbsent(readIndexStatus.getIndex(), k -> new ArrayList(10)).add(readIndexStatus);
                }
            }
            finally {
                if (doUnlock) {
                    ReadOnlyServiceImpl.this.lock.unlock();
                }
            }
        }

        private void notifyFail(Status status) {
            long nowMs = Utils.monotonicMs();
            for (ReadIndexEvent event : this.events) {
                ReadOnlyServiceImpl.this.node.getNodeMetrics().recordLatency("read-index", nowMs - event.startTime);
                if (event.done == null) continue;
                event.done.run(status, -1L, event.requestContext.get());
            }
        }
    }

    private class ReadIndexEventHandler
    implements EventHandler<ReadIndexEvent> {
        private List<ReadIndexEvent> events;

        private ReadIndexEventHandler() {
            this.events = new ArrayList<ReadIndexEvent>(ReadOnlyServiceImpl.this.raftOptions.getApplyBatch());
        }

        public void onEvent(ReadIndexEvent newEvent, long sequence, boolean endOfBatch) throws Exception {
            if (newEvent.shutdownLatch != null) {
                ReadOnlyServiceImpl.this.executeReadIndexEvents(this.events);
                newEvent.shutdownLatch.countDown();
                return;
            }
            this.events.add(newEvent);
            if (this.events.size() >= ReadOnlyServiceImpl.this.raftOptions.getApplyBatch() || endOfBatch) {
                ReadOnlyServiceImpl.this.executeReadIndexEvents(this.events);
                this.events = new ArrayList<ReadIndexEvent>(ReadOnlyServiceImpl.this.raftOptions.getApplyBatch());
            }
        }
    }

    private static class ReadIndexEventFactory
    implements EventFactory<ReadIndexEvent> {
        private ReadIndexEventFactory() {
        }

        public ReadIndexEvent newInstance() {
            return new ReadIndexEvent();
        }
    }

    private static class ReadIndexEvent {
        Bytes requestContext;
        ReadIndexClosure done;
        CountDownLatch shutdownLatch;
        long startTime;

        private ReadIndexEvent() {
        }
    }
}

