/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rpc.impl.cli;

import com.alipay.sofa.jraft.Node;
import com.alipay.sofa.jraft.NodeManager;
import com.alipay.sofa.jraft.Status;
import com.alipay.sofa.jraft.entity.PeerId;
import com.alipay.sofa.jraft.error.RaftError;
import com.alipay.sofa.jraft.rpc.CliRequests;
import com.alipay.sofa.jraft.rpc.RpcRequestClosure;
import com.alipay.sofa.jraft.rpc.RpcResponseFactory;
import com.alipay.sofa.jraft.rpc.impl.cli.BaseCliRequestProcessor;
import com.google.protobuf.Message;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;

public class GetLeaderRequestProcessor
extends BaseCliRequestProcessor<CliRequests.GetLeaderRequest> {
    public GetLeaderRequestProcessor(Executor executor) {
        super(executor);
    }

    @Override
    protected String getPeerId(CliRequests.GetLeaderRequest request) {
        return request.getPeerId();
    }

    @Override
    protected String getGroupId(CliRequests.GetLeaderRequest request) {
        return request.getGroupId();
    }

    @Override
    protected Message processRequest0(BaseCliRequestProcessor.CliRequestContext ctx, CliRequests.GetLeaderRequest request, RpcRequestClosure done) {
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Message processRequest(CliRequests.GetLeaderRequest request, RpcRequestClosure done) {
        List<Object> nodes = new ArrayList();
        String groupId = this.getGroupId(request);
        if (request.hasPeerId()) {
            PeerId peerId = new PeerId();
            String peerIdStr = this.getPeerId(request);
            if (!peerId.parse(peerIdStr)) return RpcResponseFactory.newResponse(RaftError.EINVAL, "Fail to parse peer id %", peerIdStr);
            Status st = new Status();
            nodes.add(this.getNode(groupId, peerId, st));
            if (!st.isOk()) {
                return RpcResponseFactory.newResponse(st);
            }
        } else {
            nodes = NodeManager.getInstance().getNodesByGroupId(groupId);
        }
        if (nodes == null || nodes.isEmpty()) {
            return RpcResponseFactory.newResponse(RaftError.ENOENT, "No nodes in group %s", groupId);
        }
        for (Node node : nodes) {
            PeerId leader = node.getLeaderId();
            if (leader == null || leader.isEmpty()) continue;
            return CliRequests.GetLeaderResponse.newBuilder().setLeaderId(leader.toString()).build();
        }
        return RpcResponseFactory.newResponse(RaftError.EAGAIN, "Unknown leader", new Object[0]);
    }

    public String interest() {
        return CliRequests.GetLeaderRequest.class.getName();
    }
}

