/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.storage.impl;

import com.alipay.sofa.jraft.core.NodeMetrics;
import com.alipay.sofa.jraft.entity.LocalStorageOutter;
import com.alipay.sofa.jraft.entity.PeerId;
import com.alipay.sofa.jraft.option.RaftOptions;
import com.alipay.sofa.jraft.storage.RaftMetaStorage;
import com.alipay.sofa.jraft.storage.io.ProtoBufFile;
import com.alipay.sofa.jraft.util.Utils;
import com.google.protobuf.Message;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalRaftMetaStorage
implements RaftMetaStorage {
    private static final Logger LOG = LoggerFactory.getLogger(LocalRaftMetaStorage.class);
    private static final String RAFT_META = "raft_meta";
    private boolean isInited;
    private final String path;
    private long term;
    private PeerId votedFor = new PeerId();
    private final RaftOptions raftOptions;
    private final NodeMetrics nodeMetrics;

    public LocalRaftMetaStorage(String path, RaftOptions raftOptions, NodeMetrics nodeMetrics) {
        this.path = path;
        this.raftOptions = raftOptions;
        this.nodeMetrics = nodeMetrics;
    }

    @Override
    public synchronized boolean init(Void opts) {
        if (this.isInited) {
            LOG.warn("Raft meta storage is already inited.");
            return true;
        }
        try {
            FileUtils.forceMkdir((File)new File(this.path));
        }
        catch (IOException e) {
            LOG.error("Fail to mkdir {}", (Object)this.path);
            return false;
        }
        if (this.load()) {
            this.isInited = true;
            return true;
        }
        return false;
    }

    private boolean load() {
        ProtoBufFile pbFile = this.newPbFile();
        try {
            LocalStorageOutter.StablePBMeta meta = (LocalStorageOutter.StablePBMeta)pbFile.load();
            if (meta != null) {
                this.term = meta.getTerm();
                return this.votedFor.parse(meta.getVotedfor());
            }
            return true;
        }
        catch (FileNotFoundException e) {
            return true;
        }
        catch (IOException e) {
            LOG.error("Fail to load raft meta storage", (Throwable)e);
            return false;
        }
    }

    private ProtoBufFile newPbFile() {
        String mPath = this.path + File.separator + RAFT_META;
        return new ProtoBufFile(mPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean save() {
        boolean bl;
        long start = Utils.monotonicMs();
        LocalStorageOutter.StablePBMeta meta = LocalStorageOutter.StablePBMeta.newBuilder().setTerm(this.term).setVotedfor(this.votedFor.toString()).build();
        ProtoBufFile pbFile = this.newPbFile();
        try {
            bl = pbFile.save((Message)meta, this.raftOptions.isSyncMeta());
        }
        catch (IOException e) {
            boolean bl2;
            try {
                LOG.error("Fail to save raft meta", (Throwable)e);
                bl2 = false;
            }
            catch (Throwable throwable) {
                long cost = Utils.monotonicMs() - start;
                if (this.nodeMetrics != null) {
                    this.nodeMetrics.recordLatency("save-raft-meta", cost);
                }
                LOG.info("Save raft meta, path={}, term={}, votedFor={}, cost time={} ms", new Object[]{this.path, this.term, this.votedFor, cost});
                throw throwable;
            }
            long cost = Utils.monotonicMs() - start;
            if (this.nodeMetrics != null) {
                this.nodeMetrics.recordLatency("save-raft-meta", cost);
            }
            LOG.info("Save raft meta, path={}, term={}, votedFor={}, cost time={} ms", new Object[]{this.path, this.term, this.votedFor, cost});
            return bl2;
        }
        long cost = Utils.monotonicMs() - start;
        if (this.nodeMetrics != null) {
            this.nodeMetrics.recordLatency("save-raft-meta", cost);
        }
        LOG.info("Save raft meta, path={}, term={}, votedFor={}, cost time={} ms", new Object[]{this.path, this.term, this.votedFor, cost});
        return bl;
    }

    @Override
    public void shutdown() {
        this.save();
    }

    @Override
    public boolean setTerm(long term) {
        if (this.isInited) {
            this.term = term;
            return this.save();
        }
        LOG.warn("LocalRaftMetaStorage not init(), path={}", (Object)this.path);
        return false;
    }

    @Override
    public long getTerm() {
        if (this.isInited) {
            return this.term;
        }
        LOG.warn("LocalRaftMetaStorage not init(), path={}", (Object)this.path);
        return -1L;
    }

    @Override
    public boolean setVotedFor(PeerId peerId) {
        if (this.isInited) {
            this.votedFor = peerId;
            return this.save();
        }
        LOG.warn("LocalRaftMetaStorage not init(), path={}", (Object)this.path);
        return false;
    }

    @Override
    public PeerId getVotedFor() {
        if (this.isInited) {
            return this.votedFor;
        }
        LOG.warn("LocalRaftMetaStorage not init(), path={}", (Object)this.path);
        return null;
    }

    @Override
    public boolean setTermAndVotedFor(long term, PeerId peerId) {
        if (this.isInited) {
            this.votedFor = peerId;
            this.term = term;
            return this.save();
        }
        LOG.warn("LocalRaftMetaStorage not init(), path={}", (Object)this.path);
        return false;
    }

    public String toString() {
        return "RaftMetaStorageImpl [path=" + this.path + ", term=" + this.term + ", votedFor=" + this.votedFor + "]";
    }
}

