/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.storage.snapshot.local;

import com.alipay.sofa.jraft.entity.LocalFileMetaOutter;
import com.alipay.sofa.jraft.entity.LocalStorageOutter;
import com.alipay.sofa.jraft.entity.RaftOutter;
import com.alipay.sofa.jraft.option.RaftOptions;
import com.alipay.sofa.jraft.storage.io.ProtoBufFile;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.ZeroByteStringHelper;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalSnapshotMetaTable {
    private static final Logger LOG = LoggerFactory.getLogger(LocalSnapshotMetaTable.class);
    private final Map<String, LocalFileMetaOutter.LocalFileMeta> fileMap = new HashMap<String, LocalFileMetaOutter.LocalFileMeta>();
    private final RaftOptions raftOptions;
    private RaftOutter.SnapshotMeta meta;

    public LocalSnapshotMetaTable(RaftOptions raftOptions) {
        this.raftOptions = raftOptions;
    }

    public ByteBuffer saveToByteBufferAsRemote() {
        LocalStorageOutter.LocalSnapshotPbMeta.Builder pbMetaBuilder = LocalStorageOutter.LocalSnapshotPbMeta.newBuilder();
        if (this.hasMeta()) {
            pbMetaBuilder.setMeta(this.meta);
        }
        for (Map.Entry<String, LocalFileMetaOutter.LocalFileMeta> entry : this.fileMap.entrySet()) {
            LocalStorageOutter.LocalSnapshotPbMeta.File.Builder fb = LocalStorageOutter.LocalSnapshotPbMeta.File.newBuilder();
            fb.setName(entry.getKey());
            fb.setMeta(entry.getValue());
            pbMetaBuilder.addFiles(fb.build());
        }
        return ByteBuffer.wrap(pbMetaBuilder.build().toByteArray());
    }

    public boolean loadFromIoBufferAsRemote(ByteBuffer buf) {
        if (buf == null) {
            LOG.error("Null buf to load.");
            return false;
        }
        try {
            LocalStorageOutter.LocalSnapshotPbMeta pbMeta = LocalStorageOutter.LocalSnapshotPbMeta.parseFrom(ZeroByteStringHelper.wrap(buf));
            if (pbMeta == null) {
                LOG.error("Fail to load meta from buffer");
                return false;
            }
            return this.loadFromPbMeta(pbMeta);
        }
        catch (InvalidProtocolBufferException e) {
            LOG.error("Fail to parse LocalSnapshotPbMeta from byte buffer", (Throwable)e);
            return false;
        }
    }

    public boolean addFile(String fileName, LocalFileMetaOutter.LocalFileMeta meta) {
        return this.fileMap.putIfAbsent(fileName, meta) == null;
    }

    public boolean removeFile(String fileName) {
        return this.fileMap.remove(fileName) != null;
    }

    public boolean saveToFile(String path) throws IOException {
        LocalStorageOutter.LocalSnapshotPbMeta.Builder pbMeta = LocalStorageOutter.LocalSnapshotPbMeta.newBuilder();
        if (this.hasMeta()) {
            pbMeta.setMeta(this.meta);
        }
        for (Map.Entry<String, LocalFileMetaOutter.LocalFileMeta> entry : this.fileMap.entrySet()) {
            LocalStorageOutter.LocalSnapshotPbMeta.File f = LocalStorageOutter.LocalSnapshotPbMeta.File.newBuilder().setName(entry.getKey()).setMeta(entry.getValue()).build();
            pbMeta.addFiles(f);
        }
        ProtoBufFile pbFile = new ProtoBufFile(path);
        return pbFile.save((Message)pbMeta.build(), this.raftOptions.isSyncMeta());
    }

    public boolean hasMeta() {
        return this.meta != null && this.meta.isInitialized();
    }

    public LocalFileMetaOutter.LocalFileMeta getFileMeta(String fileName) {
        return this.fileMap.get(fileName);
    }

    public Set<String> listFiles() {
        return this.fileMap.keySet();
    }

    public void setMeta(RaftOutter.SnapshotMeta meta) {
        this.meta = meta;
    }

    public RaftOutter.SnapshotMeta getMeta() {
        return this.meta;
    }

    public boolean loadFromFile(String path) throws IOException {
        ProtoBufFile pbFile = new ProtoBufFile(path);
        LocalStorageOutter.LocalSnapshotPbMeta pbMeta = (LocalStorageOutter.LocalSnapshotPbMeta)pbFile.load();
        if (pbMeta == null) {
            LOG.error("Fail to load meta from {}", (Object)path);
            return false;
        }
        return this.loadFromPbMeta(pbMeta);
    }

    private boolean loadFromPbMeta(LocalStorageOutter.LocalSnapshotPbMeta pbMeta) {
        this.meta = pbMeta.hasMeta() ? pbMeta.getMeta() : null;
        this.fileMap.clear();
        for (LocalStorageOutter.LocalSnapshotPbMeta.File f : pbMeta.getFilesList()) {
            this.fileMap.put(f.getName(), f.getMeta());
        }
        return true;
    }
}

