/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.util.timer;

import com.alipay.sofa.jraft.util.ExecutorServiceHelper;
import com.alipay.sofa.jraft.util.NamedThreadFactory;
import com.alipay.sofa.jraft.util.Requires;
import com.alipay.sofa.jraft.util.ThreadPoolUtil;
import com.alipay.sofa.jraft.util.timer.Timeout;
import com.alipay.sofa.jraft.util.timer.Timer;
import com.alipay.sofa.jraft.util.timer.TimerTask;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class DefaultTimer
implements Timer {
    private final ScheduledExecutorService scheduledExecutorService;

    public DefaultTimer(int workerNum, String name) {
        this.scheduledExecutorService = ThreadPoolUtil.newScheduledBuilder().coreThreads(workerNum).poolName(name).enableMetric(true).threadFactory(new NamedThreadFactory(name, true)).build();
    }

    @Override
    public Timeout newTimeout(TimerTask task, long delay, TimeUnit unit) {
        Requires.requireNonNull(task, "task");
        Requires.requireNonNull(unit, "unit");
        TimeoutTask timeoutTask = new TimeoutTask(task);
        ScheduledFuture<?> future = this.scheduledExecutorService.schedule(new TimeoutTask(task), delay, unit);
        timeoutTask.setFuture(future);
        return timeoutTask.getTimeout();
    }

    @Override
    public Set<Timeout> stop() {
        ExecutorServiceHelper.shutdownAndAwaitTermination(this.scheduledExecutorService);
        return Collections.emptySet();
    }

    private class TimeoutTask
    implements Runnable {
        private final TimerTask task;
        private final Timeout timeout;
        private volatile ScheduledFuture<?> future;

        private TimeoutTask(final TimerTask task) {
            this.task = task;
            this.timeout = new Timeout(){

                @Override
                public Timer timer() {
                    return DefaultTimer.this;
                }

                @Override
                public TimerTask task() {
                    return task;
                }

                @Override
                public boolean isExpired() {
                    return false;
                }

                @Override
                public boolean isCancelled() {
                    ScheduledFuture f = TimeoutTask.this.future;
                    return f != null && f.isCancelled();
                }

                @Override
                public boolean cancel() {
                    ScheduledFuture f = TimeoutTask.this.future;
                    return f != null && f.cancel(true);
                }
            };
        }

        public Timeout getTimeout() {
            return this.timeout;
        }

        public ScheduledFuture<?> getFuture() {
            return this.future;
        }

        public void setFuture(ScheduledFuture<?> future) {
            this.future = future;
        }

        @Override
        public void run() {
            try {
                this.task.run(this.timeout);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

