/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.closure;

import com.alipay.sofa.jraft.Closure;
import com.alipay.sofa.jraft.Status;
import com.alipay.sofa.jraft.util.Requires;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class JoinableClosure
implements Closure {
    private final CountDownLatch latch = new CountDownLatch(1);
    private final Closure closure;

    public JoinableClosure(Closure closure) {
        this.closure = Requires.requireNonNull(closure, "closure");
    }

    @Override
    public void run(Status status) {
        this.closure.run(status);
        this.latch.countDown();
    }

    public void join() throws InterruptedException {
        this.latch.await();
    }

    public void join(long timeoutMillis) throws InterruptedException, TimeoutException {
        if (!this.latch.await(timeoutMillis, TimeUnit.MILLISECONDS)) {
            throw new TimeoutException("joined timeout");
        }
    }

    public Closure getClosure() {
        return this.closure;
    }
}

