/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.entity;

import com.alipay.sofa.jraft.entity.Checksum;
import com.alipay.sofa.jraft.entity.EnumOutter;
import com.alipay.sofa.jraft.entity.LogId;
import com.alipay.sofa.jraft.entity.PeerId;
import com.alipay.sofa.jraft.entity.codec.v1.V1Decoder;
import com.alipay.sofa.jraft.entity.codec.v1.V1Encoder;
import com.alipay.sofa.jraft.util.CrcUtil;
import java.nio.ByteBuffer;
import java.util.List;

public class LogEntry
implements Checksum {
    public static final ByteBuffer EMPTY_DATA = ByteBuffer.wrap(new byte[0]);
    private EnumOutter.EntryType type;
    private LogId id = new LogId(0L, 0L);
    private List<PeerId> peers;
    private List<PeerId> oldPeers;
    private List<PeerId> learners;
    private List<PeerId> oldLearners;
    private ByteBuffer data = EMPTY_DATA;
    private long checksum;
    private boolean hasChecksum;

    public List<PeerId> getLearners() {
        return this.learners;
    }

    public void setLearners(List<PeerId> learners) {
        this.learners = learners;
    }

    public List<PeerId> getOldLearners() {
        return this.oldLearners;
    }

    public void setOldLearners(List<PeerId> oldLearners) {
        this.oldLearners = oldLearners;
    }

    public LogEntry() {
    }

    public LogEntry(EnumOutter.EntryType type) {
        this.type = type;
    }

    public boolean hasLearners() {
        return this.learners != null && !this.learners.isEmpty() || this.oldLearners != null && !this.oldLearners.isEmpty();
    }

    @Override
    public long checksum() {
        long c = this.checksum(this.type.getNumber(), this.id.checksum());
        c = this.checksum(this.peers, c);
        c = this.checksum(this.oldPeers, c);
        c = this.checksum(this.learners, c);
        c = this.checksum(this.oldLearners, c);
        if (this.data != null && this.data.hasRemaining()) {
            c = this.checksum(c, CrcUtil.crc64(this.data));
        }
        return c;
    }

    @Deprecated
    public byte[] encode() {
        return V1Encoder.INSTANCE.encode(this);
    }

    @Deprecated
    public boolean decode(byte[] content) {
        if (content == null || content.length == 0) {
            return false;
        }
        if (content[0] != -72) {
            return false;
        }
        V1Decoder.INSTANCE.decode(this, content);
        return true;
    }

    public boolean hasChecksum() {
        return this.hasChecksum;
    }

    public boolean isCorrupted() {
        return this.hasChecksum && this.checksum != this.checksum();
    }

    public long getChecksum() {
        return this.checksum;
    }

    public void setChecksum(long checksum) {
        this.checksum = checksum;
        this.hasChecksum = true;
    }

    public EnumOutter.EntryType getType() {
        return this.type;
    }

    public void setType(EnumOutter.EntryType type) {
        this.type = type;
    }

    public LogId getId() {
        return this.id;
    }

    public void setId(LogId id) {
        this.id = id;
    }

    public List<PeerId> getPeers() {
        return this.peers;
    }

    public void setPeers(List<PeerId> peers) {
        this.peers = peers;
    }

    public List<PeerId> getOldPeers() {
        return this.oldPeers;
    }

    public void setOldPeers(List<PeerId> oldPeers) {
        this.oldPeers = oldPeers;
    }

    public ByteBuffer getData() {
        return this.data;
    }

    public void setData(ByteBuffer data) {
        this.data = data;
    }

    public String toString() {
        return "LogEntry [type=" + (Object)((Object)this.type) + ", id=" + this.id + ", peers=" + this.peers + ", oldPeers=" + this.oldPeers + ", learners=" + this.learners + ", oldLearners=" + this.oldLearners + ", data=" + (this.data != null ? this.data.remaining() : 0) + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.data == null ? 0 : this.data.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.learners == null ? 0 : this.learners.hashCode());
        result = 31 * result + (this.oldLearners == null ? 0 : this.oldLearners.hashCode());
        result = 31 * result + (this.oldPeers == null ? 0 : this.oldPeers.hashCode());
        result = 31 * result + (this.peers == null ? 0 : this.peers.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LogEntry other = (LogEntry)obj;
        if (this.data == null ? other.data != null : !this.data.equals(other.data)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.learners == null ? other.learners != null : !this.learners.equals(other.learners)) {
            return false;
        }
        if (this.oldLearners == null ? other.oldLearners != null : !this.oldLearners.equals(other.oldLearners)) {
            return false;
        }
        if (this.oldPeers == null ? other.oldPeers != null : !this.oldPeers.equals(other.oldPeers)) {
            return false;
        }
        if (this.peers == null ? other.peers != null : !this.peers.equals(other.peers)) {
            return false;
        }
        return this.type == other.type;
    }
}

