/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.lookout.common.top;

import com.alipay.lookout.api.Id;
import com.alipay.lookout.api.NoopRegistry;
import com.alipay.lookout.api.Registry;
import com.alipay.lookout.common.top.DefaultTopGauger;
import com.alipay.lookout.common.top.NoopTopGauger;
import com.alipay.lookout.common.top.TopGauger;
import com.alipay.lookout.jdk8.Function;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public final class TopUtil {
    private static final String TOP_NUM_TAG_KEY = "n";
    static Executor executor = new ThreadPoolExecutor(Runtime.getRuntime().availableProcessors(), Runtime.getRuntime().availableProcessors(), 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(10000), TopUtil.getNamedThreadFactory(), new ThreadPoolExecutor.DiscardPolicy());
    static final ConcurrentHashMap<Id, TopGauger> cache = new ConcurrentHashMap();
    static final int MAX_TOP_CACHE_SIZE = 200;

    private TopUtil() {
    }

    private static ThreadFactory getNamedThreadFactory() {
        return new DefaultThreadFactory("top-metrics-pool", true);
    }

    public static TopGauger topGauger(Registry registry, Id id, int maxNumber) {
        return TopUtil.topGauger(registry, id, maxNumber, Order.DESC);
    }

    public static TopGauger topGauger(final Registry registry, final Id id, final int maxNumber, final Order order) {
        if (registry instanceof NoopRegistry || id == NoopRegistry.INSTANCE.createId(null)) {
            return NoopTopGauger.INSTANCE;
        }
        Id key = id.withTag(TOP_NUM_TAG_KEY, String.valueOf(maxNumber));
        TopGauger topGauger = TopUtil.computeIfAbsent(cache, key, new Function<Object, TopGauger>(){

            @Override
            public TopGauger apply(Object obj) {
                return new DefaultTopGauger(registry, id, maxNumber, order);
            }
        });
        return topGauger == null ? NoopTopGauger.INSTANCE : topGauger;
    }

    private static <E, T> T computeIfAbsent(ConcurrentHashMap<E, T> map, E key, Function<?, T> f) {
        T m = map.get(key);
        if (m == null) {
            if (map.size() > 200) {
                return null;
            }
            T tmp = f.apply(null);
            m = map.putIfAbsent(key, tmp);
            if (m == null) {
                m = tmp;
            }
        }
        return m;
    }

    private static class DefaultThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger poolId = new AtomicInteger();
        private final AtomicInteger nextId = new AtomicInteger();
        private final String prefix;
        private final boolean daemon;
        private final int priority;

        public DefaultThreadFactory(String poolName) {
            this(poolName, false, 5);
        }

        public DefaultThreadFactory(String poolName, boolean daemon) {
            this(poolName, daemon, 5);
        }

        public DefaultThreadFactory(String poolName, int priority) {
            this(poolName, false, priority);
        }

        public DefaultThreadFactory(String poolName, boolean daemon, int priority) {
            if (poolName == null) {
                throw new NullPointerException("poolName");
            }
            if (priority < 1 || priority > 10) {
                throw new IllegalArgumentException("priority: " + priority + " (expected: Thread.MIN_PRIORITY <= priority <= Thread.MAX_PRIORITY)");
            }
            this.prefix = poolName + '-' + poolId.incrementAndGet() + '-';
            this.daemon = daemon;
            this.priority = priority;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, this.prefix + this.nextId.incrementAndGet());
            try {
                if (t.isDaemon()) {
                    if (!this.daemon) {
                        t.setDaemon(false);
                    }
                } else if (this.daemon) {
                    t.setDaemon(true);
                }
                if (t.getPriority() != this.priority) {
                    t.setPriority(this.priority);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return t;
        }
    }

    static class Entry<K, V> {
        private final K key;
        private V value;

        public Entry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        public K getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return Entry.eq(this.key, e.getKey());
        }

        private static boolean eq(Object o1, Object o2) {
            return o1 == null ? o2 == null : o1.equals(o2);
        }

        public int hashCode() {
            return this.key == null ? 0 : this.key.hashCode();
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }

    public static enum Order {
        DESC,
        ASC;

    }
}

